/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.support.StorageCache;
import com.verizon.ads.utils.HttpUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class FileStorageCache
extends StorageCache {
    private static final Logger logger = Logger.getInstance(FileStorageCache.class);
    private static final String WHO = FileStorageCache.class.getSimpleName();
    private static final String ERROR_URL_NOT_PROVIDED = "url cannot be null or empty";
    private static final int DEFAULT_DOWNLOAD_TIMEOUT = 5000;
    private static final int MAX_THREADS = 3;
    private final ExecutorService executorService;
    private AtomicInteger nextId = new AtomicInteger(0);
    private Map<String, File> cachedFiles = new ConcurrentHashMap<String, File>();
    private volatile boolean aborted = false;
    private final Set<String> queuedRequests = new HashSet<String>();
    public static final int ERROR_CREATING_FILE = -1;
    public static final int ERROR_DOWNLOAD_FAILED = -2;

    public FileStorageCache(StorageCache storageRoot) {
        super(new File(storageRoot.getCacheDirectory(), UUID.randomUUID().toString() + "/"));
        this.executorService = Executors.newFixedThreadPool(3);
    }

    public File getFile(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            logger.e(ERROR_URL_NOT_PROVIDED);
            return null;
        }
        return this.cachedFiles.get(url);
    }

    private void addFile(String url, File file) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            logger.e(ERROR_URL_NOT_PROVIDED);
            return;
        }
        if (file == null) {
            logger.e("file cannot be null");
            return;
        }
        this.cachedFiles.put(url, file);
    }

    private void deleteFile(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            logger.e(ERROR_URL_NOT_PROVIDED);
            return;
        }
        File file = this.getFile(url);
        if (file == null) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("url is not in cache: %s", url));
            }
            return;
        }
        StorageCache.deleteFile(file);
        this.cachedFiles.remove(url);
    }

    public void deleteCache() {
        logger.d("Deleting cache");
        this.stopAllDownloads();
        this.deleteCacheDirectory();
        this.cachedFiles.clear();
    }

    public String getCacheDirectoryPath() {
        File cacheDirectory = this.getCacheDirectory();
        if (cacheDirectory == null) {
            return null;
        }
        return cacheDirectory.getAbsolutePath();
    }

    public void downloadAndCacheFile(String url, FileStorageCacheListener listener) {
        this.downloadAndCacheFile(url, listener, 5000);
    }

    @SuppressLint(value={"DefaultLocale"})
    public void downloadAndCacheFile(final String url, final FileStorageCacheListener listener, final int timeout) {
        if (listener == null) {
            logger.e("Listener cannot be null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            listener.onComplete(url, new ErrorInfo(WHO, ERROR_URL_NOT_PROVIDED, -2));
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                File file;
                if (FileStorageCache.this.aborted) {
                    listener.onComplete(url, new ErrorInfo(WHO, "Download aborted", -2));
                    return;
                }
                if (Logger.isLogLevelEnabled((int)3)) {
                    logger.d(String.format("Downloading file for url: %s", url));
                }
                if (FileStorageCache.this.cachedFiles.containsKey(url)) {
                    if (Logger.isLogLevelEnabled((int)3)) {
                        logger.d(String.format("url is already in the cache: %s", url));
                    }
                    listener.onComplete(url, null);
                    return;
                }
                try {
                    file = FileStorageCache.this.createFile(String.format("%d-%s", FileStorageCache.this.nextId.addAndGet(1), URLUtil.guessFileName((String)url, null, null)));
                }
                catch (Exception e) {
                    listener.onComplete(url, new ErrorInfo(WHO, String.format("Error creating temporary file for url: %s", url), -1));
                    return;
                }
                HttpUtils.Response response = HttpUtils.getFileFromGetRequest((String)url, (File)file, (int)(timeout > 0 ? timeout : 5000));
                if (response.file != null) {
                    FileStorageCache.this.addFile(url, file);
                    listener.onComplete(url, null);
                } else {
                    ErrorInfo errorInfo = new ErrorInfo(WHO, String.format("File download failed with code %d", response.code), -2);
                    listener.onComplete(url, errorInfo);
                }
            }
        });
    }

    public void stopAllDownloads() {
        this.aborted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueFileForDownload(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            logger.w(ERROR_URL_NOT_PROVIDED);
            return;
        }
        if (Logger.isLogLevelEnabled((int)3)) {
            if (this.queuedRequests.contains(url)) {
                logger.d(String.format("File already queued for download: %s", url));
            } else {
                logger.d(String.format("File queued for download: %s", url));
            }
        }
        Set<String> set = this.queuedRequests;
        synchronized (set) {
            this.queuedRequests.add(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumQueuedFiles() {
        Set<String> set = this.queuedRequests;
        synchronized (set) {
            return this.queuedRequests.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadQueuedFiles(FileStorageCacheListener listener, int timeout) {
        if (listener == null) {
            logger.e("Listener cannot be null");
            return;
        }
        Set<String> set = this.queuedRequests;
        synchronized (set) {
            Iterator<String> iter = this.queuedRequests.iterator();
            while (iter.hasNext()) {
                String url = iter.next();
                this.downloadAndCacheFile(url, listener, timeout);
                iter.remove();
            }
        }
    }

    public static interface FileStorageCacheListener {
        public void onComplete(String var1, ErrorInfo var2);
    }
}

