/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support.utils;

import android.app.Activity;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewTreeObserver;
import com.verizon.ads.ActivityStateManager;
import com.verizon.ads.Logger;
import com.verizon.ads.VASAds;
import com.verizon.ads.support.utils.ViewUtils;
import com.verizon.ads.utils.ThreadUtils;
import java.lang.ref.WeakReference;

public class ViewabilityWatcher
implements ViewTreeObserver.OnPreDrawListener,
View.OnLayoutChangeListener,
View.OnAttachStateChangeListener,
Runnable {
    private static final Logger logger = Logger.getInstance(ViewabilityWatcher.class);
    int minViewabilityPercent = -1;
    Rect clipRect = new Rect();
    volatile boolean watching = false;
    volatile ActivityStateManager.ActivityState lifecycleState;
    volatile boolean listeningToActivity = false;
    volatile boolean observingViewTree = false;
    volatile WeakReference<View> viewRef;
    volatile ViewabilityListener listener;
    volatile ActivityStateManager.ActivityObserver activityObserver;
    public static final int AT_LEAST_ONE_PIXEL_VIEWABLE = -1;
    public volatile boolean viewable = false;
    public float exposedPercentage;
    public Rect mbr;

    public ViewabilityWatcher(View view, ViewabilityListener listener) {
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d("Creating viewability watcher <" + this + "> for view <" + view + ">");
        }
        this.viewRef = new WeakReference<View>(view);
        this.listener = listener;
        this.activityObserver = new ActivityStateManager.ActivityObserver(){

            public void onResumed(Activity activity) {
                ViewabilityWatcher.this.lifecycleState = ActivityStateManager.ActivityState.RESUMED;
                ViewabilityWatcher.this.checkViewable();
            }

            public void onPaused(Activity activity) {
                ViewabilityWatcher.this.lifecycleState = ActivityStateManager.ActivityState.PAUSED;
                ViewabilityWatcher.this.checkViewable();
            }
        };
    }

    public void setMinViewabilityPercent(int percent) {
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d("Setting the viewability percentage.\n\tViewability watcher: " + this + "\n\tPercentage: " + percent);
        }
        this.minViewabilityPercent = percent;
    }

    public void startWatching() {
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d("Starting watcher.\n\tViewability watcher: " + this + "\n\tView: " + this.viewRef.get());
        }
        ThreadUtils.postOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                View view = (View)ViewabilityWatcher.this.viewRef.get();
                if (view == null || ViewabilityWatcher.this.watching) {
                    return;
                }
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)ViewabilityWatcher.this);
                view.addOnLayoutChangeListener((View.OnLayoutChangeListener)ViewabilityWatcher.this);
                ViewabilityWatcher.this.watching = true;
                if (view.getWindowToken() != null) {
                    ViewabilityWatcher.this.addObserver(view);
                    ViewabilityWatcher.this.listenToActivity(view, true);
                }
                ViewabilityWatcher.this.checkViewable();
            }
        });
    }

    public void stopWatching() {
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d("Stopping watcher.\n\tViewability watcher: " + this + "\n\tView: " + this.viewRef.get());
        }
        ThreadUtils.postOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                View view = (View)ViewabilityWatcher.this.viewRef.get();
                if (view == null || !ViewabilityWatcher.this.watching) {
                    return;
                }
                ViewabilityWatcher.this.removeObserver(view);
                view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)ViewabilityWatcher.this);
                view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)ViewabilityWatcher.this);
                ViewabilityWatcher.this.watching = false;
                ViewabilityWatcher.this.listenToActivity(view, false);
            }
        });
    }

    public void onViewAttachedToWindow(View view) {
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d("onViewAttachedToWindow called.\n\tViewability watcher: " + this + "\n\tView: " + view);
        }
        if (this.watching) {
            this.addObserver(view);
            this.listenToActivity(view, true);
            this.checkViewable();
        }
    }

    public void onViewDetachedFromWindow(View view) {
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d("onViewDetachedFromWindow called.\n\tViewability watcher: " + this + "\n\tView: " + view);
        }
        if (this.watching) {
            this.removeObserver(view);
            this.listenToActivity(view, false);
            this.checkViewable();
        }
    }

    private void addObserver(View view) {
        if (this.observingViewTree) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("Trying to set view tree observer when already set");
            }
            return;
        }
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("Adding ViewTreeObserver.\n\tViewability watcher: " + this + "\n\tViewTreeObserver: " + viewTreeObserver + "\n\tView: " + view);
            }
            viewTreeObserver.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            this.observingViewTree = true;
        }
    }

    private void removeObserver(View view) {
        if (!this.observingViewTree) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("Trying to remove view tree observer when not set");
            }
            return;
        }
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d("Removing ViewTreeObserver.\n\tViewability watcher: " + this + "\n\tViewTreeObserver: " + viewTreeObserver + "\n\tView: " + view);
            }
            viewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
        this.observingViewTree = false;
    }

    private void listenToActivity(View view, boolean listen) {
        Activity activity = ViewUtils.getActivityForView(view);
        if (activity == null) {
            return;
        }
        if (listen && !this.listeningToActivity) {
            VASAds.getActivityStateManager().registerActivityObserver(activity, this.activityObserver);
            this.lifecycleState = VASAds.getActivityStateManager().getState(activity);
        } else if (!listen && this.listeningToActivity) {
            VASAds.getActivityStateManager().unregisterActivityObserver(activity, this.activityObserver);
        }
        this.listeningToActivity = listen;
    }

    public boolean onPreDraw() {
        if (this.watching) {
            this.checkViewable();
        }
        return true;
    }

    public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (this.watching) {
            this.checkViewable();
        }
    }

    private void checkViewable() {
        ThreadUtils.postOnUiThread((Runnable)this);
    }

    private boolean isViewViewable(View view) {
        if (view == null) {
            return false;
        }
        if (this.minViewabilityPercent == 0) {
            return true;
        }
        if (this.lifecycleState == ActivityStateManager.ActivityState.RESUMED && view.isShown() && (double)view.getAlpha() > 0.0 && view.getGlobalVisibleRect(this.clipRect)) {
            long visibleViewArea = this.clipRect.height() * this.clipRect.width();
            long totalArea = view.getHeight() * view.getWidth();
            this.exposedPercentage = 100.0f * ((float)visibleViewArea / (float)totalArea);
            this.mbr = new Rect(this.clipRect);
            if (visibleViewArea > 0L) {
                if (this.minViewabilityPercent == -1) {
                    return true;
                }
                if (totalArea > 0L) {
                    long percentVisible = 100L * visibleViewArea / totalArea;
                    return percentVisible >= (long)this.minViewabilityPercent;
                }
            }
        } else {
            this.exposedPercentage = 0.0f;
            this.mbr = null;
        }
        return false;
    }

    @Override
    public void run() {
        View view = (View)this.viewRef.get();
        boolean currentlyViewable = this.isViewViewable(view);
        if (this.viewable != currentlyViewable) {
            this.viewable = currentlyViewable;
            if (this.watching && this.listener != null) {
                if (Logger.isLogLevelEnabled((int)3)) {
                    logger.d("Notifying listener of viewability change.\n\tViewability watcher: " + this + "\n\tView: " + view + "\n\tViewable: " + this.viewable);
                }
                this.listener.onViewableChanged(this.viewable);
            }
        }
    }

    public static interface ViewabilityListener {
        public void onViewableChanged(boolean var1);
    }
}

