/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.nativeopenrtbnativeadapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import com.verizon.ads.AdContent;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.nativeopenrtbnativeadapter.NativeImageView;
import com.verizon.ads.nativeplacement.BaseNativeComponentBundle;
import com.verizon.ads.nativeplacement.NativeAdAdapter;
import com.verizon.ads.nativeplacement.NativeComponentBundle;
import com.verizon.ads.nativeplacement.VASDisplayMediaView;
import com.verizon.ads.nativeplacement.VASTextView;
import com.verizon.ads.openrtbnativecontroller.OpenRTBNativeController;
import java.util.List;

public class NativeOpenRTBNativeAdapter
implements NativeAdAdapter {
    private static final Logger logger = Logger.getInstance(NativeOpenRTBNativeAdapter.class);
    private OpenRTBNativeController openRTBNativeController;
    private NativeAdAdapter.NativeAdAdapterListener nativeAdAdapterListener;

    public ErrorInfo prepare(AdContent adContent) {
        this.openRTBNativeController = new OpenRTBNativeController();
        return this.openRTBNativeController.prepare(adContent);
    }

    public void setListener(NativeAdAdapter.NativeAdAdapterListener nativeAdAdapterListener) {
        this.nativeAdAdapterListener = nativeAdAdapterListener;
    }

    public String getAdType() {
        return this.openRTBNativeController.getAdType();
    }

    public void loadComponents(int componentsTimeout, final NativeAdAdapter.LoadComponentsListener listener) {
        if (listener == null) {
            logger.e("LoadComponentsListener cannot be null");
            return;
        }
        this.openRTBNativeController.loadAssets(componentsTimeout, new OpenRTBNativeController.LoadAssetsListener(){

            public void onComplete(ErrorInfo errorInfo) {
                listener.onComplete(errorInfo);
            }
        });
    }

    public void abortLoadComponents() {
        this.openRTBNativeController.abortLoadAssets();
    }

    public boolean isComponentLoaded(String componentId) {
        OpenRTBNativeController.Asset asset = this.openRTBNativeController.getAsset(componentId);
        return asset != null && asset.isLoaded();
    }

    public VASTextView getText(NativeComponentBundle nativeComponentBundle, Context context, String componentId) {
        OpenRTBNativeController.Asset asset = this.openRTBNativeController.getAsset(componentId);
        String value = null;
        if (asset instanceof OpenRTBNativeController.TitleAsset) {
            value = ((OpenRTBNativeController.TitleAsset)asset).getText();
        } else if (asset instanceof OpenRTBNativeController.DataAsset) {
            value = ((OpenRTBNativeController.DataAsset)asset).getValue();
        }
        if (value == null) {
            logger.e(String.format("Asset does not support text view: %s", componentId));
            return null;
        }
        VASTextView vasTextView = new VASTextView(context);
        vasTextView.setText((CharSequence)value);
        this.setupClickListener(nativeComponentBundle, context, componentId, (View)vasTextView);
        return vasTextView;
    }

    public VASDisplayMediaView getDisplayMedia(NativeComponentBundle nativeComponentBundle, Context context, String componentId) {
        OpenRTBNativeController.Asset asset = this.openRTBNativeController.getAsset(componentId);
        OpenRTBNativeController.ImageAsset imageAsset = null;
        if (asset instanceof OpenRTBNativeController.ImageAsset) {
            imageAsset = (OpenRTBNativeController.ImageAsset)asset;
        }
        if (imageAsset == null) {
            logger.e(String.format("Asset does not support image view: %s", componentId));
            return null;
        }
        Bitmap bitmap = imageAsset.getBitmap();
        if (bitmap == null) {
            logger.e(String.format("Bitmap not loaded for image: %s", componentId));
            return null;
        }
        NativeImageView openRTBImageView = new NativeImageView(context);
        int width = imageAsset.getWidth() == null ? bitmap.getWidth() : imageAsset.getWidth().intValue();
        int height = imageAsset.getHeight() == null ? bitmap.getHeight() : imageAsset.getHeight().intValue();
        openRTBImageView.setBitmap(bitmap, width, height);
        this.setupClickListener(nativeComponentBundle, context, componentId, (View)openRTBImageView);
        return openRTBImageView;
    }

    public BaseNativeComponentBundle getBundle(NativeComponentBundle nativeComponentBundle, String componentId) {
        logger.w("Open RTB Native deos not support component bundles.");
        return null;
    }

    public List<String> getComponentIds(NativeComponentBundle nativeComponentBundle) {
        return this.openRTBNativeController.getComponentIds();
    }

    public void invokeDefaultAction(Context context) {
        this.openRTBNativeController.invokeDefaultAction(context, new OpenRTBNativeController.OpenRTBNativeControllerListener(){

            public void onAdLeftApplication() {
                NativeAdAdapter.NativeAdAdapterListener listener = NativeOpenRTBNativeAdapter.this.nativeAdAdapterListener;
                if (listener != null) {
                    listener.onAdLeftApplication();
                }
            }
        });
    }

    public void fireImpression() {
        this.openRTBNativeController.fireImpression();
    }

    void setupClickListener(final NativeComponentBundle nativeComponentBundle, final Context context, final String componentId, View view) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                final NativeAdAdapter.NativeAdAdapterListener listener = NativeOpenRTBNativeAdapter.this.nativeAdAdapterListener;
                NativeOpenRTBNativeAdapter.this.openRTBNativeController.fireClick(context, componentId, new OpenRTBNativeController.OpenRTBNativeControllerListener(){

                    public void onAdLeftApplication() {
                        if (listener != null) {
                            listener.onAdLeftApplication();
                        }
                    }
                });
                if (listener != null) {
                    listener.onClicked(nativeComponentBundle);
                }
            }
        });
    }

    public void release() {
        this.openRTBNativeController.release();
        this.nativeAdAdapterListener = null;
    }
}

