/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.interstitialwebadapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.verizon.ads.AdContent;
import com.verizon.ads.AdSession;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.interstitialplacement.InterstitialAdAdapter;
import com.verizon.ads.interstitialwebadapter.WebViewActivity;
import com.verizon.ads.support.utils.ViewUtils;
import com.verizon.ads.utils.ThreadUtils;
import com.verizon.ads.webcontroller.WebController;
import java.lang.ref.WeakReference;

public class InterstitialWebAdapter
implements InterstitialAdAdapter,
WebController.WebControllerListener {
    private static final Logger logger = Logger.getInstance(InterstitialWebAdapter.class);
    private static final String WHO = InterstitialWebAdapter.class.getSimpleName();
    private static final int ERROR_NULL_ACTIVITY = -1;
    private static final int ERROR_INCORRECT_STATE = -2;
    private static final int ERROR_ATTACH_FAILED = -3;
    private WeakReference<WebViewActivity> activityRef;
    private WebController webController;
    private InterstitialAdAdapter.InterstitialAdAdapterListener interstitialAdAdapterListener;
    private boolean immersive = true;
    private int enterAnimationId = 0;
    private int exitAnimationId = 0;
    private AdContent adContent;
    private volatile AdapterState state = AdapterState.DEFAULT;

    public InterstitialWebAdapter() {
        this.webController = new WebController();
        this.webController.setListener((WebController.WebControllerListener)this);
    }

    public synchronized ErrorInfo prepare(AdSession adSession, AdContent adContent) {
        if (this.state != AdapterState.DEFAULT) {
            logger.d("prepare failed; adapter is not in the default state.");
            return new ErrorInfo(WHO, "Adapter not in the default state.", -2);
        }
        ErrorInfo errorInfo = this.webController.prepare(adSession, adContent.getContent());
        this.state = errorInfo == null ? AdapterState.PREPARED : AdapterState.ERROR;
        this.adContent = adContent;
        return errorInfo;
    }

    public AdContent getAdContent() {
        return this.adContent;
    }

    public synchronized void release() {
        this.state = AdapterState.RELEASED;
        if (this.webController != null) {
            this.webController.release();
            this.webController = null;
        }
        ThreadUtils.postOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                InterstitialWebAdapter.this.finishActivity();
            }
        });
    }

    synchronized boolean isReleased() {
        return this.state == AdapterState.RELEASED;
    }

    public synchronized void load(Context context, int timeout, final InterstitialAdAdapter.LoadViewListener listener) {
        if (listener == null) {
            logger.e("LoadViewListener cannot be null.");
            return;
        }
        if (this.state != AdapterState.PREPARED) {
            logger.d("Adapter must be in prepared state to load.");
            listener.onComplete(new ErrorInfo(WHO, "Adapter not in prepared state.", -2));
            return;
        }
        this.state = AdapterState.LOADING;
        this.webController.load(context, timeout, new WebController.LoadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(ErrorInfo errorInfo) {
                InterstitialWebAdapter interstitialWebAdapter = InterstitialWebAdapter.this;
                synchronized (interstitialWebAdapter) {
                    if (InterstitialWebAdapter.this.state == AdapterState.LOADING) {
                        if (errorInfo == null) {
                            InterstitialWebAdapter.this.state = AdapterState.LOADED;
                        } else {
                            InterstitialWebAdapter.this.state = AdapterState.ERROR;
                        }
                        listener.onComplete(errorInfo);
                    } else {
                        listener.onComplete(new ErrorInfo(WHO, "Adapter not in the loading state.", -2));
                    }
                }
            }
        }, true);
    }

    public synchronized void abortLoad() {
        logger.d("Attempting to abort load.");
        if (this.state == AdapterState.PREPARED || this.state == AdapterState.LOADING) {
            this.state = AdapterState.ABORTED;
        }
    }

    public synchronized void show(Context context) {
        if (this.state != AdapterState.LOADED) {
            logger.d("Show failed; Adapter not loaded.");
            if (this.interstitialAdAdapterListener != null) {
                this.interstitialAdAdapterListener.onError(new ErrorInfo(WHO, "Show failed; Adapter not loaded.", -2));
            }
            return;
        }
        this.state = AdapterState.SHOWING;
        WebViewActivity.WebViewActivityConfig config = new WebViewActivity.WebViewActivityConfig(this);
        config.setImmersive(this.isImmersiveEnabled()).setTransitionAnimation(this.getEnterAnimationId(), this.getExitAnimationId());
        WebViewActivity.launch(context, config);
    }

    public synchronized void setListener(InterstitialAdAdapter.InterstitialAdAdapterListener interstitialAdAdapterListener) {
        if (this.state != AdapterState.PREPARED && this.state != AdapterState.DEFAULT && this.state != AdapterState.LOADED) {
            logger.e("InterstitialAdAdapterListener can only be set in default, prepared, or loaded state.");
            return;
        }
        this.interstitialAdAdapterListener = interstitialAdAdapterListener;
    }

    public void setImmersiveEnabled(boolean immersive) {
        this.immersive = immersive;
    }

    public boolean isImmersiveEnabled() {
        return this.immersive;
    }

    public void setEnterAnimation(int enterAnimationId) {
        this.enterAnimationId = enterAnimationId;
    }

    public int getEnterAnimationId() {
        return this.enterAnimationId;
    }

    public void setExitAnimation(int exitAnimationId) {
        this.exitAnimationId = exitAnimationId;
    }

    public int getExitAnimationId() {
        return this.exitAnimationId;
    }

    public void onClicked() {
        if (this.interstitialAdAdapterListener != null) {
            this.interstitialAdAdapterListener.onClicked();
        }
    }

    public void onAdLeftApplication() {
        if (this.interstitialAdAdapterListener != null) {
            this.interstitialAdAdapterListener.onAdLeftApplication();
        }
    }

    public void close() {
        this.finishActivity();
    }

    public void onError(ErrorInfo errorInfo) {
        if (this.interstitialAdAdapterListener != null) {
            this.interstitialAdAdapterListener.onError(errorInfo);
        }
    }

    public void expand() {
    }

    public void resize() {
    }

    public void unload() {
        this.state = AdapterState.UNLOADED;
        this.finishActivity();
    }

    public void fireImpression() {
        if (this.webController != null) {
            this.webController.fireImpression();
        }
    }

    WebViewActivity getActivity() {
        if (this.activityRef == null) {
            return null;
        }
        return (WebViewActivity)((Object)this.activityRef.get());
    }

    void finishActivity() {
        WebViewActivity activity = this.getActivity();
        if (activity != null && !activity.isFinishing()) {
            activity.finish();
        }
    }

    void attach(final WebViewActivity activity) {
        final InterstitialAdAdapter.InterstitialAdAdapterListener adAdapterListener = this.interstitialAdAdapterListener;
        if (activity == null) {
            this.state = AdapterState.ERROR;
            if (adAdapterListener != null) {
                adAdapterListener.onError(new ErrorInfo(WHO, "Could not attach WebView. Parent activity was null.", -1));
            }
            return;
        }
        this.activityRef = new WeakReference<WebViewActivity>(activity);
        final RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        final View vasAdView = this.webController.getVASAdsMRAIDWebView();
        if (vasAdView == null) {
            adAdapterListener.onError(new ErrorInfo(WHO, "Could not attach WebView. Verizon ad view provided by controller was null.", -3));
            return;
        }
        ThreadUtils.postOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (InterstitialWebAdapter.this.state != AdapterState.SHOWING && InterstitialWebAdapter.this.state != AdapterState.SHOWN) {
                    logger.d("adapter not in shown or showing state; aborting show.");
                    activity.finish();
                    return;
                }
                ViewUtils.attachView((ViewGroup)activity.getRootView(), (View)vasAdView, (ViewGroup.LayoutParams)layoutParams);
                InterstitialWebAdapter.this.state = AdapterState.SHOWN;
                if (adAdapterListener != null) {
                    adAdapterListener.onShown();
                }
            }
        });
    }

    void onClosed() {
        if (this.interstitialAdAdapterListener != null) {
            this.interstitialAdAdapterListener.onClosed();
        }
    }

    static enum AdapterState {
        DEFAULT,
        PREPARED,
        LOADING,
        LOADED,
        SHOWING,
        SHOWN,
        ERROR,
        ABORTED,
        UNLOADED,
        RELEASED;

    }
}

