/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.inlinewebadapter;

import android.content.Context;
import com.verizon.ads.AdContent;
import com.verizon.ads.ContentFilter;
import com.verizon.ads.Logger;
import com.verizon.ads.Plugin;
import com.verizon.ads.inlineplacement.InlineAdView;
import com.verizon.ads.inlinewebadapter.InlineWebAdapter;
import com.verizon.ads.utils.TextUtils;
import java.net.URI;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class InlineWebAdapterPlugin
extends Plugin {
    private static final Logger logger = Logger.getInstance(InlineWebAdapterPlugin.class);
    private static final String PLUGIN_ID = "com.verizon.ads.inlinewebadapter";
    private static final String PLUGIN_NAME = "Inline Web Adapter";
    private static final String PLUGIN_VERSION = "1.2.0-dba4ec1";
    private static final String PLUGIN_AUTHOR = "Verizon";
    private static final URI PLUGIN_EMAIL = null;
    private static final URL PLUGIN_WEBSITE = null;
    private static final int PLUGIN_MIN_API_LEVEL = 1;
    private static final Pattern PATTERN_HTML = Pattern.compile("<HTML", 2);
    private static final Pattern PATTERN_HEAD_OR_BODY = Pattern.compile("<HEAD|<BODY", 2);
    private static final Pattern PATTERN_OTHER_HTML_TAGS = Pattern.compile("<(SCRIPT|IMG|IFRAME|A|DIV|SPAN|P|H[1-6])[ />]", 2);

    public InlineWebAdapterPlugin(Context applicationContext) {
        super(applicationContext, PLUGIN_ID, PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR, PLUGIN_EMAIL, PLUGIN_WEBSITE, 1);
    }

    protected boolean prepare() {
        logger.d("Preparing InlineWebAdapterPlugin");
        this.registerAdAdapter(InlineAdView.class, InlineWebAdapter.class, new InlineWebContentFilter());
        return true;
    }

    protected void onPluginEnabled() {
    }

    protected void onPluginDisabled() {
    }

    static class InlineWebContentFilter
    implements ContentFilter {
        InlineWebContentFilter() {
        }

        public boolean accepts(AdContent adContent) {
            if (adContent == null) {
                return false;
            }
            String content = adContent.getContent();
            if (TextUtils.isEmpty((String)content)) {
                return false;
            }
            try {
                new JSONObject(content);
                return false;
            }
            catch (JSONException jSONException) {
                Matcher matcher = PATTERN_HEAD_OR_BODY.matcher(content);
                if (matcher.find()) {
                    return true;
                }
                matcher.usePattern(PATTERN_HTML);
                if (matcher.find()) {
                    return false;
                }
                matcher.usePattern(PATTERN_OTHER_HTML_TAGS);
                return matcher.find();
            }
        }
    }
}

