/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.inlinewebadapter;

import android.content.Context;
import android.view.View;
import com.verizon.ads.AdContent;
import com.verizon.ads.AdSession;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.inlineplacement.AdSize;
import com.verizon.ads.inlineplacement.InlineAdAdapter;
import com.verizon.ads.webcontroller.WebController;
import java.util.Map;

public class InlineWebAdapter
implements InlineAdAdapter,
WebController.WebControllerListener {
    private static final Logger logger = Logger.getInstance(InlineWebAdapter.class);
    private static final String WHO = InlineWebAdapter.class.getSimpleName();
    private static final int ERROR_INCORRECT_STATE = -1;
    private static final int ERROR_MISSING_AD_SIZE = -2;
    private static final int ERROR_MISSING_META_DATA = -3;
    private WebController webController;
    private InlineAdAdapter.InlineAdAdapterListener inlineAdAdapterListener;
    private boolean immersive = true;
    private volatile AdapterState state = AdapterState.DEFAULT;
    private AdSize adSize;
    private AdContent adContent;

    public InlineWebAdapter() {
        this.webController = new WebController();
        this.webController.setListener((WebController.WebControllerListener)this);
    }

    public synchronized ErrorInfo prepare(AdSession adSession, AdContent adContent) {
        if (this.state != AdapterState.DEFAULT) {
            logger.d("prepare failed; adapter is not in the default state.");
            return new ErrorInfo(WHO, "Adapter not in the default state.", -1);
        }
        ErrorInfo errorInfo = this.webController.prepare(adSession, adContent.getContent());
        if (adContent.getMetadata() == null) {
            return new ErrorInfo(WHO, "Ad content is missing meta data.", -3);
        }
        if (!(adContent.getMetadata().get("ad_size") instanceof Map)) {
            return new ErrorInfo(WHO, "Ad content is missing ad size.", -2);
        }
        Map adSizeMap = (Map)adContent.getMetadata().get("ad_size");
        this.adSize = this.convertAdSizeMapToAdSize(adSizeMap);
        if (this.adSize == null) {
            return new ErrorInfo(WHO, "Ad content is missing ad size.", -2);
        }
        this.state = errorInfo == null ? AdapterState.PREPARED : AdapterState.ERROR;
        this.adContent = adContent;
        return errorInfo;
    }

    public AdContent getAdContent() {
        return this.adContent;
    }

    private AdSize convertAdSizeMapToAdSize(Map<String, Integer> adSizeMap) {
        if (adSizeMap == null) {
            logger.e("AdSizeMap must not be null.");
            return null;
        }
        if (!(adSizeMap.get("w") instanceof Integer) || !(adSizeMap.get("h") instanceof Integer)) {
            logger.e("Width and/or height are not integers.");
            return null;
        }
        return new AdSize(adSizeMap.get("w").intValue(), adSizeMap.get("h").intValue());
    }

    public void fireImpression() {
        if (this.webController != null) {
            this.webController.fireImpression();
        }
    }

    public synchronized void release() {
        this.state = AdapterState.RELEASED;
        if (this.webController != null) {
            this.webController.release();
            this.webController = null;
        }
    }

    public void setListener(InlineAdAdapter.InlineAdAdapterListener inlineAdAdapterListener) {
        if (this.state != AdapterState.PREPARED && this.state != AdapterState.DEFAULT && this.state != AdapterState.LOADED) {
            logger.e("InlineAdAdapterListener can only be set in default, prepared, or loaded state.");
            return;
        }
        this.inlineAdAdapterListener = inlineAdAdapterListener;
    }

    public boolean isImmersiveEnabled() {
        return this.immersive;
    }

    public void setImmersiveEnabled(boolean immersive) {
        if (this.webController != null) {
            this.webController.setImmersiveEnabled(immersive);
        }
        this.immersive = immersive;
    }

    public void loadView(Context context, int loadViewTimeout, final InlineAdAdapter.LoadViewListener listener) {
        if (listener == null) {
            logger.e("LoadViewListener cannot be null.");
            return;
        }
        if (this.state != AdapterState.PREPARED) {
            logger.d("Adapter must be in prepared state to load.");
            listener.onComplete(new ErrorInfo(WHO, "Adapter not in prepared state.", -1));
            return;
        }
        this.state = AdapterState.LOADING;
        this.webController.load(context, loadViewTimeout, new WebController.LoadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(ErrorInfo errorInfo) {
                InlineWebAdapter inlineWebAdapter = InlineWebAdapter.this;
                synchronized (inlineWebAdapter) {
                    if (InlineWebAdapter.this.state == AdapterState.LOADING) {
                        if (errorInfo != null) {
                            InlineWebAdapter.this.state = AdapterState.ERROR;
                            listener.onComplete(errorInfo);
                            return;
                        }
                        InlineWebAdapter.this.state = AdapterState.LOADED;
                        listener.onComplete(null);
                    } else {
                        listener.onComplete(new ErrorInfo(WHO, "Adapter not in the loading state.", -1));
                    }
                }
            }
        }, false);
    }

    public synchronized void abortLoad() {
        logger.d("Attempting to abort load.");
        if (this.state == AdapterState.PREPARED || this.state == AdapterState.LOADING) {
            this.state = AdapterState.ABORTED;
        }
    }

    public View getView() {
        if (this.state != AdapterState.LOADED) {
            logger.d("Adapter must be in loaded state to getView.");
            return null;
        }
        if (this.webController == null) {
            logger.d("WebController cannot be null to getView.");
            this.state = AdapterState.ERROR;
            return null;
        }
        View vasAdView = this.webController.getVASAdsMRAIDWebView();
        if (vasAdView == null) {
            logger.d("Verizon Ad View cannot be null to getView.");
            this.state = AdapterState.ERROR;
            return null;
        }
        return vasAdView;
    }

    public AdSize getAdSize() {
        return this.adSize;
    }

    public boolean isResized() {
        return this.webController.isResized();
    }

    public boolean isExpanded() {
        return this.webController.isExpanded();
    }

    public void onClicked() {
        if (this.inlineAdAdapterListener != null) {
            this.inlineAdAdapterListener.onClicked();
        }
    }

    public void onAdLeftApplication() {
        if (this.inlineAdAdapterListener != null) {
            this.inlineAdAdapterListener.onAdLeftApplication();
        }
    }

    public void close() {
        if (this.inlineAdAdapterListener != null) {
            this.inlineAdAdapterListener.onCollapsed();
        }
    }

    public void onError(ErrorInfo errorInfo) {
        if (this.inlineAdAdapterListener != null) {
            this.inlineAdAdapterListener.onError(errorInfo);
        }
    }

    public void expand() {
        if (this.inlineAdAdapterListener != null) {
            this.inlineAdAdapterListener.onExpanded();
        }
    }

    public void resize() {
        if (this.inlineAdAdapterListener != null) {
            this.inlineAdAdapterListener.onResized();
        }
    }

    public void unload() {
    }

    static enum AdapterState {
        DEFAULT,
        PREPARED,
        LOADING,
        LOADED,
        ERROR,
        ABORTED,
        RELEASED;

    }
}

