/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.parser.util;

import com.veracode.parser.util.StringUtility;

public final class Convert {
    public static Object changeType(String input, Class<?> type) {
        Object result = null;
        if (type == String.class) {
            result = input;
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            result = Boolean.parseBoolean(input);
        } else if (type == Character.class || type == Character.TYPE) {
            result = Character.valueOf(input.charAt(0));
        } else if (type == Byte.class || type == Byte.TYPE) {
            result = Byte.parseByte(input);
        } else if (type == Short.class || type == Short.TYPE) {
            result = Short.parseShort(input);
        } else if (type == Integer.class || type == Integer.TYPE) {
            result = Integer.parseInt(input);
        } else if (type == Long.class || type == Long.TYPE) {
            result = Long.parseLong(input);
        } else if (type == Float.class || type == Float.TYPE) {
            result = Float.valueOf(Float.parseFloat(input));
        } else if (type == Double.class || type == Double.TYPE) {
            result = Double.parseDouble(input);
        } else if (type.isEnum()) {
            Enum[] enumArray = (Enum[])type.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum e = enumArray[n2];
                if (StringUtility.compare(e.name(), input, true) == 0) {
                    result = e;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static Object toDefaultValue(Class<?> type) {
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        return null;
    }

    private Convert() {
    }
}

