/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.parser;

import com.veracode.parser.CommandLineParserSettings;
import com.veracode.parser.core.CLineParser;
import com.veracode.parser.enums.ParserState;
import com.veracode.parser.exceptions.ParseException;
import com.veracode.parser.options.CommandLineOptionsBase;
import com.veracode.parser.text.TextBuilder;
import com.veracode.parser.util.Assert;
import com.veracode.parser.util.StringUtility;

public final class CommandLineParser {
    private CommandLineParserSettings _settings;

    public CommandLineParserSettings getSettings() {
        return this._settings;
    }

    public void setSettings(CommandLineParserSettings settings) {
        this._settings = settings;
    }

    public boolean parse(CommandLineOptionsBase options, String[] arguments) {
        block10: {
            Assert.notNull(options, "options");
            Assert.notNull(arguments, "arguments");
            if (this._settings.getWriter() == null) break block10;
            boolean showOptions = false;
            showOptions = this.parseHelp(options, arguments);
            if (showOptions || !this.parseItems(options, arguments)) {
                TextBuilder textBuilder = TextBuilder.createInstance(options);
                if (textBuilder != null) {
                    if (showOptions || arguments.length == 0) {
                        this._settings.getWriter().print(textBuilder.getAllText());
                    } else if (this._settings.getWriteErrorsOnly()) {
                        this._settings.getWriter().print(textBuilder.getOnlyErrorText());
                    } else {
                        this._settings.getWriter().print(textBuilder.getAllTextSansOptions());
                    }
                }
                return false;
            }
            return true;
        }
        try {
            return this.parseItems(options, arguments);
        }
        catch (ParseException clpe) {
            throw clpe;
        }
        catch (Exception e) {
            throw new ParseException("Generic Parse Exception", e);
        }
    }

    private boolean parseHelp(CommandLineOptionsBase options, String[] arguments) {
        boolean caseSensitive = this._settings.getCaseSensitive();
        int i = 0;
        while (i < arguments.length) {
            if (StringUtility.compare(arguments[i], String.valueOf(options.longSwitch) + "help", !caseSensitive) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean parseItems(CommandLineOptionsBase options, String[] arguments) {
        boolean hadError = false;
        CLineParser parser = new CLineParser(options, this._settings, arguments);
        while (parser.moveNext()) {
            ParserState result;
            if (StringUtility.isNullOrEmpty(parser.getCurrent()) || (result = parser.parseCurrentItem()) != ParserState.Failure) continue;
            hadError = true;
        }
        return !(hadError |= !parser.enforceRules());
    }

    public CommandLineParser() {
        this._settings = new CommandLineParserSettings();
    }

    public CommandLineParser(CommandLineParserSettings settings) {
        this._settings = settings;
    }
}

