/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="config-do-not-execute", configurator="", aggregator=false, requiresProject=true, instantiationStrategy=InstantiationStrategy.PER_LOOKUP, executionStrategy="once-per-session", threadSafe=true, requiresOnline=false, requiresReports=false, requiresDependencyResolution=ResolutionScope.NONE, requiresDependencyCollection=ResolutionScope.NONE, requiresDirectInvocation=false, defaultPhase=LifecyclePhase.NONE, inheritByDefault=true)
public enum Property {
    help("false", "h", true),
    disable("false", "d", true),
    disableIfBranchRegex("", "dibr"),
    disableBranchComparison("false", "dbc", true),
    referenceBranch("refs/remotes/origin/develop", "rb"),
    fetchReferenceBranch("false", "frb", true),
    baseBranch("HEAD", "bb"),
    fetchBaseBranch("false", "fbb", true),
    useJschAgentProxy("true", "ujap"),
    compareToMergeBase("true", "ctmb", true),
    uncommitted("true", "uc", true),
    untracked("true", "ut", true),
    skipIfPathMatches("", "sipm"),
    excludePathRegex("", "epr"),
    includePathRegex("", "ipr"),
    buildAll("false", "ba", true),
    buildAllIfNoChanges("false", "bainc", true),
    buildDownstream("always", "bd", true),
    buildUpstream("derived", "bu", true),
    buildUpstreamMode("changed", "bum"),
    skipTestsForUpstreamModules("false", "stfum", true),
    argsForUpstreamModules("", "afum"),
    forceBuildModules("", "fbm"),
    excludeDownstreamModulesPackagedAs("", "edmpa"),
    disableSelectedProjectsHandling("false", "dsph", true),
    failOnMissingGitDir("true", "fomgd", true),
    failOnError("true", "foe", true),
    logImpactedTo("", "lit");

    public static final String PREFIX = "gib.";
    private static final Logger LOGGER;
    private final String prefixedName = "gib." + this.name();
    private final String prefixedShortName;
    private final List<String> nameCandidatesForSystemProperties;
    private final List<String> nameCandidatesForPluginProperties;
    private final List<String> nameCandidatesForProjectProperties;
    private final String defaultValue;
    private final boolean mapEmptyValueToTrue;

    private Property(String defaultValue, String unprefixedShortName) {
        this(defaultValue, unprefixedShortName, false);
    }

    private Property(String defaultValue, String unprefixedShortName, boolean mapNoValueToTrue) {
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.prefixedShortName = PREFIX + unprefixedShortName;
        this.nameCandidatesForSystemProperties = Stream.of(this.prefixedName, this.prefixedShortName, this.deprecatedPrefixedName()).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.nameCandidatesForPluginProperties = Stream.of(this.name(), this.deprecatedName().orElse(null)).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.nameCandidatesForProjectProperties = Stream.of(this.prefixedName, this.deprecatedPrefixedName()).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.mapEmptyValueToTrue = mapNoValueToTrue;
    }

    private String exemplify() {
        return String.format("%-83s<!-- or -D%-13s -->", "<" + this.prefixedName + ">" + this.defaultValue + "</" + this.prefixedName + ">", this.prefixedShortName + "=...");
    }

    public String prefixedName() {
        return this.prefixedName;
    }

    public String prefixedShortName() {
        return this.prefixedShortName;
    }

    public Optional<String> deprecatedName() {
        return Optional.empty();
    }

    public final String deprecatedPrefixedName() {
        return this.deprecatedName().map(PREFIX::concat).orElse(null);
    }

    public ValueWithOriginContext getValueWithOriginContext(Properties pluginProperties, Properties projectProperties) {
        Optional<ValueWithOriginContext> valueWithName = this.getValueWithOriginContext(this.nameCandidatesForPluginProperties, pluginProperties, "plugin");
        if (!valueWithName.isPresent()) {
            valueWithName = this.getValueWithOriginContext(this.nameCandidatesForSystemProperties, System.getProperties(), "system");
        }
        if (!valueWithName.isPresent()) {
            valueWithName = this.getValueWithOriginContext(this.nameCandidatesForProjectProperties, projectProperties, "project");
        }
        ValueWithOriginContext finalValueWithOriginContext = valueWithName.orElseGet(() -> new ValueWithOriginContext(this.defaultValue, this.name(), "default"));
        LOGGER.debug("{}", (Object)finalValueWithOriginContext);
        return finalValueWithOriginContext;
    }

    public String getValue(Properties pluginProperties, Properties projectProperties) {
        return this.getValueWithOriginContext((Properties)pluginProperties, (Properties)projectProperties).value;
    }

    public Optional<String> getValueOpt(Properties pluginProperties, Properties projectProperties) {
        String value = this.getValue(pluginProperties, projectProperties);
        return value.isEmpty() ? Optional.empty() : Optional.of(value);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isBoolean() {
        return this.defaultValue.equals("true") || this.defaultValue.equals("false");
    }

    protected Optional<Property> getPropertyToMigrateTo() {
        return Optional.empty();
    }

    private Optional<ValueWithOriginContext> getValueWithOriginContext(List<String> nameCandidates, Properties properties, String propertiesDesc) {
        return properties.isEmpty() ? Optional.empty() : nameCandidates.stream().map(nameCandidate -> this.getValueWithOriginContext((String)nameCandidate, properties, propertiesDesc)).filter(Objects::nonNull).findFirst();
    }

    private ValueWithOriginContext getValueWithOriginContext(String name, Properties properties, String propertiesDesc) {
        String deprecatedName;
        String value = properties.getProperty(name);
        if (value == null) {
            return null;
        }
        boolean prefixed = name.startsWith(PREFIX);
        String string = deprecatedName = prefixed ? this.deprecatedPrefixedName() : (String)this.deprecatedName().orElse(null);
        if (name.equals(deprecatedName)) {
            LOGGER.warn("'{}' has been renamed to '{}' and the old name will be removed in an upcoming release. Please adjust your configuration!", (Object)deprecatedName, (Object)(prefixed ? this.prefixedName : this.name()));
        }
        this.getPropertyToMigrateTo().ifPresent(prop -> LOGGER.warn("'{}' is deprecated and will be removed in an upcoming release. Please migrate to '{}'!", (Object)name, (Object)(prefixed ? prop.prefixedName + (name.equals(this.prefixedShortName) ? " (" + prop.prefixedShortName + ")" : "") : prop.name())));
        if (this.mapEmptyValueToTrue && value.isEmpty()) {
            value = "true";
        }
        return new ValueWithOriginContext(value, name, propertiesDesc);
    }

    public static void checkProperties(Properties pluginProperties, Properties projectProperties) {
        String invalidProjectPropertyNames;
        String invalidPluginPropertyNames;
        String errorDetails = "";
        String invalidSystemPropertyNames = Property.checkProperties(System.getProperties(), true, p -> p.nameCandidatesForSystemProperties);
        if (!invalidSystemPropertyNames.isEmpty()) {
            errorDetails = errorDetails + "\n\tinvalid system properties:\n\t\t" + invalidSystemPropertyNames;
        }
        if (!(invalidPluginPropertyNames = Property.checkProperties(pluginProperties, false, p -> p.nameCandidatesForPluginProperties)).isEmpty()) {
            errorDetails = errorDetails + "\n\tinvalid plugin properties:\n\t\t" + invalidPluginPropertyNames;
        }
        if (!(invalidProjectPropertyNames = Property.checkProperties(projectProperties, true, p -> p.nameCandidatesForProjectProperties)).isEmpty()) {
            errorDetails = errorDetails + "\n\tinvalid project properties:\n\t\t" + invalidProjectPropertyNames;
        }
        if (!errorDetails.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid GIB properties found:%s%n%nAllowed properties:%n%s%nFor a plugin-<configuration>, use the properties without the %s prefix.", errorDetails, Property.exemplifyAll(), PREFIX));
        }
    }

    private static String checkProperties(Properties properties, boolean prefixed, Function<Property, List<String>> availableNamesProvider) {
        Set allAvailableNames = Arrays.stream(Property.values()).flatMap(p -> ((List)availableNamesProvider.apply((Property)((Object)p))).stream()).collect(Collectors.toSet());
        return properties.isEmpty() ? "" : properties.keySet().stream().map(k -> (String)k).filter(k -> (!prefixed || k.startsWith(PREFIX)) && !allAvailableNames.contains(k)).collect(Collectors.joining("\n\t\t"));
    }

    public static String exemplifyAll() {
        StringBuilder builder = new StringBuilder();
        builder.append("<properties>\n");
        for (Property value : Property.values()) {
            builder.append("    ").append(value.exemplify()).append("\n");
        }
        builder.append("</properties>\n");
        return builder.toString();
    }

    static {
        LOGGER = LoggerFactory.getLogger(Property.class);
    }

    public static class ValueWithOriginContext {
        public final String value;
        public final String originName;
        public final String originProperties;

        protected ValueWithOriginContext(String value, String originName, String originProperties) {
            this.value = value;
            this.originName = originName;
            this.originProperties = originProperties;
        }

        public String toString() {
            return "From " + this.originProperties + ": " + this.originName + "=" + this.value;
        }
    }
}

