/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control;

import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import com.vackosar.gitflowincrementalbuild.control.jgit.AgentProxyAwareJschConfigSessionFactory;
import com.vackosar.gitflowincrementalbuild.control.jgit.GitProvider;
import com.vackosar.gitflowincrementalbuild.control.jgit.HttpDelegatingCredentialsProvider;
import com.vackosar.gitflowincrementalbuild.entity.SkipExecutionException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DifferentFiles {
    public static final String UNSUPPORTED_WORKTREE = "JGit unsupported separate worktree checkout detected from current git dir path: ";
    private static final String HEAD = "HEAD";
    private static final String REFS_REMOTES = "refs/remotes/";
    private static final String REFS_HEADS = "refs/heads/";
    private Logger logger = LoggerFactory.getLogger(DifferentFiles.class);
    @Inject
    private GitProvider gitProvider;
    private final Map<String, String> additionalNativeGitEnvironment = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Path> get(Configuration config) throws GitAPIException, IOException {
        HashSet<Path> paths = new HashSet<Path>();
        Worker worker = null;
        try {
            worker = new Worker(this.gitProvider.get(config), config);
            worker.fetch();
            worker.checkout();
            if (!config.disableBranchComparison) {
                paths.addAll(worker.getBranchDiff());
            }
            if (config.uncommitted || config.untracked) {
                paths.addAll(worker.getChangesFromStatus());
            }
            if (worker != null) {
                worker.credentialsProvider.resetAll();
            }
        }
        catch (Throwable throwable) {
            if (worker != null) {
                worker.credentialsProvider.resetAll();
            }
            throw throwable;
        }
        return paths;
    }

    void putAdditionalNativeGitEnvironment(String key, String value) {
        this.additionalNativeGitEnvironment.put(key, value);
    }

    private class Worker {
        private final Git git;
        private final Path workTree;
        private final Configuration configuration;
        private final HttpDelegatingCredentialsProvider credentialsProvider;

        public Worker(Git git, Configuration configuration) {
            this.git = git;
            this.workTree = git.getRepository().getWorkTree().toPath().normalize().toAbsolutePath();
            this.configuration = configuration;
            this.credentialsProvider = new HttpDelegatingCredentialsProvider(this.workTree, DifferentFiles.this.additionalNativeGitEnvironment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<Path> getBranchDiff() throws IOException {
            RevCommit base = this.getBranchCommit(this.configuration.baseBranch);
            try (TreeWalk treeWalk = new TreeWalk(this.git.getRepository());){
                treeWalk.addTree((AnyObjectId)base.getTree());
                treeWalk.addTree((AnyObjectId)this.resolveReference(base).getTree());
                treeWalk.setFilter(TreeFilter.ANY_DIFF);
                treeWalk.setRecursive(true);
                Set<Path> set = this.getDiff(treeWalk, this.workTree);
                return set;
            }
        }

        private void checkout() throws IOException, GitAPIException {
            if (!(DifferentFiles.HEAD.equals(this.configuration.baseBranch) || this.configuration.baseBranch.startsWith("worktrees/") || this.git.getRepository().getFullBranch().equals(this.configuration.baseBranch))) {
                DifferentFiles.this.logger.info("Checking out base branch " + this.configuration.baseBranch + "...");
                this.git.checkout().setName(this.configuration.baseBranch).call();
            }
        }

        private void fetch() throws GitAPIException {
            if (!this.configuration.disableBranchComparison && this.configuration.fetchReferenceBranch) {
                this.fetch(this.configuration.referenceBranch);
            }
            if (this.configuration.fetchBaseBranch) {
                this.fetch(this.configuration.baseBranch);
            }
        }

        private void fetch(String branchName) throws GitAPIException {
            DifferentFiles.this.logger.info("Fetching branch " + branchName);
            if (!branchName.startsWith(DifferentFiles.REFS_REMOTES)) {
                throw new IllegalArgumentException("Branch name '" + branchName + "' is not tracking branch name since it does not start " + DifferentFiles.REFS_REMOTES);
            }
            String remoteName = this.extractRemoteName(branchName);
            String shortName = this.extractShortName(remoteName, branchName);
            FetchCommand fetchCommand = ((FetchCommand)this.git.fetch().setCredentialsProvider((CredentialsProvider)this.credentialsProvider)).setRemote(remoteName).setRefSpecs(new RefSpec[]{new RefSpec(DifferentFiles.REFS_HEADS + shortName + ":" + branchName)});
            if (this.configuration.useJschAgentProxy) {
                fetchCommand.setTransportConfigCallback(transport -> {
                    if (transport instanceof SshTransport) {
                        ((SshTransport)transport).setSshSessionFactory((SshSessionFactory)new AgentProxyAwareJschConfigSessionFactory());
                    }
                });
            }
            fetchCommand.call();
        }

        private String extractRemoteName(String branchName) {
            return branchName.split("/")[2];
        }

        private String extractShortName(String remoteName, String branchName) {
            return branchName.replaceFirst(DifferentFiles.REFS_REMOTES + remoteName + "/", "");
        }

        private RevCommit getMergeBase(RevCommit baseCommit, RevCommit referenceHeadCommit) throws IOException {
            RevWalk walk = new RevWalk(this.git.getRepository());
            walk.setRevFilter(RevFilter.MERGE_BASE);
            walk.markStart(walk.lookupCommit((AnyObjectId)baseCommit));
            walk.markStart(walk.lookupCommit((AnyObjectId)referenceHeadCommit));
            RevCommit commit = walk.next();
            walk.close();
            DifferentFiles.this.logger.info("Using merge base of id: " + commit.getId());
            return commit;
        }

        private Set<Path> getDiff(TreeWalk treeWalk, Path gitDir) throws IOException {
            HashSet<Path> paths = new HashSet<Path>();
            while (treeWalk.next()) {
                Path path = Paths.get(treeWalk.getPathString(), new String[0]).normalize();
                if (!this.pathIncluded(path)) continue;
                paths.add(gitDir.resolve(path));
            }
            return paths;
        }

        private RevCommit getBranchCommit(String branchName) throws IOException {
            Repository repository = this.git.getRepository();
            ObjectId objectId = repository.resolve(branchName);
            if (objectId == null) {
                if (repository.simplify(branchName) != null) {
                    throw new SkipExecutionException("Could not get Git ObjectId for branch of name '" + branchName + "'. Is this repository empty (no commits yet)?");
                }
                if (branchName.startsWith(DifferentFiles.REFS_REMOTES) && repository.getRemoteNames().isEmpty()) {
                    throw new SkipExecutionException("Could not get Git ObjectId for branch of name '" + branchName + "'. No remotes found at all, push still pending?");
                }
                throw new IllegalArgumentException("Git branch of name '" + branchName + "' not found.");
            }
            RevWalk walk = new RevWalk(repository);
            RevCommit commit = walk.parseCommit((AnyObjectId)objectId);
            walk.close();
            DifferentFiles.this.logger.info("Reference commit of branch " + branchName + " is commit of id: " + commit.getId());
            return commit;
        }

        private Set<Path> getChangesFromStatus() throws GitAPIException {
            HashSet changes = new HashSet();
            Status status = this.git.status().call();
            if (this.configuration.uncommitted) {
                changes.addAll(status.getUncommittedChanges());
            }
            if (this.configuration.untracked) {
                changes.addAll(status.getUntracked());
            }
            return changes.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::normalize).filter(this::pathIncluded).map(this.workTree::resolve).collect(Collectors.toSet());
        }

        private RevCommit resolveReference(RevCommit base) throws IOException {
            RevCommit refHead = this.getBranchCommit(this.configuration.referenceBranch);
            if (this.configuration.compareToMergeBase) {
                return this.getMergeBase(base, refHead);
            }
            return refHead;
        }

        private boolean pathIncluded(Path path) {
            String pathString = path.toString();
            if (this.configuration.skipIfPathMatches.map(pred -> pred.test(pathString)).orElse(false).booleanValue()) {
                throw new SkipExecutionException("Changed path matches regex defined by skipIfPathMatches: " + pathString);
            }
            boolean excluded = this.configuration.excludePathRegex.map(pred -> pred.test(pathString)).orElse(false);
            boolean included = !excluded && this.configuration.includePathRegex.map(pred -> pred.test(pathString)).orElse(true) != false;
            DifferentFiles.this.logger.debug("included {}: {}", (Object)included, (Object)pathString);
            return included;
        }
    }
}

