/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datepicker;

import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;

@Tests(value={DatePicker.class})
public class DatePickerTester<T extends DatePicker>
extends ComponentTester<T> {
    public DatePickerTester(T component) {
        super(component);
    }

    public void setValue(LocalDate date) {
        this.ensureComponentIsUsable();
        try {
            if (this.isInvalid(date)) {
                throw new IllegalArgumentException("Given date is not a valid value");
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        ((DatePicker)this.getComponent()).setValue(date);
    }

    private boolean isInvalid(LocalDate date) throws InvocationTargetException, IllegalAccessException {
        try {
            Method isInvalid = this.getMethod("isInvalid", LocalDate.class);
            return (Boolean)isInvalid.invoke(this.getComponent(), date);
        }
        catch (RuntimeException ex) {
            if (!(ex.getCause() instanceof NoSuchMethodException)) {
                throw ex;
            }
            return ((DatePicker)this.getComponent()).getDefaultValidator().apply((Object)date, null).isError();
        }
    }
}

