/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.html.NativeButton;
import com.vaadin.flow.data.renderer.BasicRenderer;
import com.vaadin.flow.data.renderer.ClickableRenderer;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class NativeButtonRenderer<SOURCE>
extends BasicRenderer<SOURCE, String>
implements ClickableRenderer<SOURCE> {
    private List<ClickableRenderer.ItemClickListener<SOURCE>> listeners = new CopyOnWriteArrayList<ClickableRenderer.ItemClickListener<SOURCE>>();

    public NativeButtonRenderer(String label) {
        this((ValueProvider<SOURCE, String>)(ValueProvider & Serializable)value -> label);
    }

    public NativeButtonRenderer(String label, ClickableRenderer.ItemClickListener<SOURCE> clickListener) {
        this(label);
        this.addItemClickListener(clickListener);
    }

    public NativeButtonRenderer(ValueProvider<SOURCE, String> labelProvider) {
        super(labelProvider);
        this.withProperty("disabled", (ValueProvider & Serializable)item -> !this.getOwner().isEnabled());
        this.withFunction("click", (SerializableConsumer & Serializable)item -> this.listeners.forEach(listener -> listener.onItemClicked(item)));
    }

    public NativeButtonRenderer(ValueProvider<SOURCE, String> labelProvider, ClickableRenderer.ItemClickListener<SOURCE> clickListener) {
        this(labelProvider);
        this.addItemClickListener(clickListener);
    }

    @Override
    public Registration addItemClickListener(ClickableRenderer.ItemClickListener<SOURCE> listener) {
        return Registration.addAndRemove(this.listeners, listener);
    }

    @Override
    public List<ClickableRenderer.ItemClickListener<SOURCE>> getItemClickListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public Component createComponent(SOURCE item) {
        Element button = ElementFactory.createButton((String)((String)this.getValueProvider().apply(item)));
        button.addEventListener("click", (DomEventListener & Serializable)event -> this.getItemClickListeners().forEach(listeners -> listeners.onItemClicked(item)));
        return ComponentUtil.componentFromElement((Element)button, NativeButton.class, (boolean)true);
    }

    @Override
    protected String getTemplateExpression() {
        return "<button @click=${click} .disabled=${item.disabled}>${item.label}</button>";
    }
}

