/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.menubar.testbench;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Element(value="vaadin-menu-bar")
public class MenuBarElement
extends TestBenchElement {
    public static final String OVERLAY_TAG = "vaadin-menu-bar-overlay";

    public List<TestBenchElement> getButtons() {
        return this.$("vaadin-menu-bar-button").all().stream().filter(element -> !this.isOverflowButton((TestBenchElement)element) && this.isVisible((TestBenchElement)element)).collect(Collectors.toList());
    }

    public TestBenchElement getOverflowButton() {
        TestBenchElement overflowButton = this.$("[slot='overflow']").first();
        if (overflowButton == null || overflowButton.hasAttribute("hidden")) {
            return null;
        }
        return overflowButton;
    }

    private boolean isOverflowButton(TestBenchElement element) {
        return element.getAttribute("slot").contains("overflow");
    }

    private boolean isVisible(TestBenchElement element) {
        return (Boolean)this.executeScript("return arguments[0].style.visibility !== 'hidden'", new Object[]{element});
    }

    public List<TestBenchElement> getSubMenuItems() {
        return this.getSubMenuItems(this.getSubMenu());
    }

    public List<TestBenchElement> getSubMenuItems(TestBenchElement overlay) {
        return overlay.$("vaadin-menu-bar-item").all();
    }

    public TestBenchElement getSubMenu() {
        this.waitForSubMenu();
        return (TestBenchElement)this.getDriver().findElement(By.tagName((String)OVERLAY_TAG));
    }

    public List<TestBenchElement> getAllSubMenus() {
        this.waitForSubMenu();
        ArrayList<TestBenchElement> elements = new ArrayList<TestBenchElement>();
        this.getDriver().findElements(By.tagName((String)OVERLAY_TAG)).forEach(element -> elements.add((TestBenchElement)element));
        return elements;
    }

    private void waitForSubMenu() {
        this.waitUntil(ExpectedConditions.presenceOfElementLocated((By)By.tagName((String)OVERLAY_TAG)));
    }
}

