/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.OnlineKeyValidator;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Product;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.prefs.Preferences;
import org.slf4j.Logger;

public class History {
    private static final String CHECK_PREFIX = "lastcheck-";

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

    static boolean isRecentlyValidated(Product product, BuildType buildType, ProKey proKey) {
        return History.isRecentlyValidated(product, Period.ofDays(1), buildType, proKey);
    }

    static boolean isRecentlyValidated(Product product, TemporalAmount period, BuildType buildType, ProKey proKey) {
        History.getLogger().debug("Checking if license for " + product + " has recently been checked for build type " + (Object)((Object)buildType) + " and pro key " + proKey);
        Instant lastCheck = History.getLastCheckTime(product, buildType, proKey);
        if (lastCheck == null) {
            return false;
        }
        Instant now = Instant.now();
        if (lastCheck.isAfter(now)) {
            return false;
        }
        Instant nextCheck = lastCheck.plus(period);
        return now.isBefore(nextCheck);
    }

    public static Instant getLastCheckTime(Product product, BuildType buildType, ProKey proKey) {
        String lastCheckKey = History.getLastCheckKey(product, buildType, proKey);
        long lastCheck = History.getPreferences().getLong(lastCheckKey, -1L);
        if (lastCheck == -1L) {
            History.getLogger().debug("License for " + product + " has never been checked");
            return null;
        }
        Instant lastCheckInstant = Instant.ofEpochMilli(lastCheck);
        History.getLogger().debug("Last check for " + product + " was on " + lastCheckInstant);
        return lastCheckInstant;
    }

    public static String getLastSubscription(Product product, ProKey proKey) {
        String lastSubscriptionKey = History.getLastSubscriptionKey(product, proKey);
        return History.getPreferences().get(lastSubscriptionKey, "");
    }

    static long setLastCheckTimeNow(Product product, BuildType buildType, ProKey proKey) {
        History.getLogger().debug("Marking license for " + product + " as checked now for buildType " + (Object)((Object)buildType));
        return History.setLastCheck(product, Instant.now(), buildType, proKey);
    }

    static long setLastCheck(Product product, Instant instant, BuildType buildType, ProKey proKey) {
        History.getLogger().debug("Marking license for " + product + " as checked on " + instant + " for buildType " + (Object)((Object)buildType) + " and pro key " + proKey);
        long timeMillis = instant.toEpochMilli();
        History.getPreferences().putLong(History.getLastCheckKey(product, buildType, proKey), timeMillis);
        return timeMillis;
    }

    public static String setLastSubscription(Product product, String subscription, ProKey proKey) {
        History.getLogger().debug("Storing subscription for " + product);
        History.getPreferences().put(History.getLastSubscriptionKey(product, proKey), subscription);
        return subscription;
    }

    static String getLastCheckKey(Product product, BuildType buildType, ProKey proKey) {
        String key = History.getKey(product, proKey);
        if (buildType != null) {
            key = key + "-" + buildType.getKey();
        }
        return History.hash(key);
    }

    static String hash(String key) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(key.getBytes());
            byte[] digest = md.digest();
            BigInteger no = new BigInteger(1, digest);
            String hash = no.toString(16);
            while (hash.length() < 32) {
                hash = "0" + hash;
            }
            return CHECK_PREFIX + hash;
        }
        catch (NoSuchAlgorithmException e) {
            return (CHECK_PREFIX + key).substring(0, 80);
        }
    }

    private static String getKey(Product product, ProKey proKey) {
        String suffix = proKey == null ? "null" : proKey.getProKey();
        return (product != null ? product.getName() + "-" + product.getVersion() + "-" : "null-null-") + suffix;
    }

    static String getLastSubscriptionKey(Product product, ProKey proKey) {
        String key = History.getKey(product, proKey) + "-sub";
        return History.hash(key);
    }

    private static Preferences getPreferences() {
        return Preferences.userNodeForPackage(OnlineKeyValidator.class);
    }

    public static void clearAll() throws Exception {
        Preferences preferences = History.getPreferences();
        for (String key : preferences.keys()) {
            if (!key.startsWith(CHECK_PREFIX)) continue;
            preferences.remove(key);
        }
    }
}

