/*
 * Copyright 2000-2024 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.pro.licensechecker;

import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HardwareAbstractionLayer;

public class MachineId {

    private static String computerId;

    public static void main(String[] args) {
        System.out.println(get());
    }

    public static String get() {
        try {
            if (computerId == null) {
                computerId = getComputerId();
            }
            return computerId;
        } catch (Exception e) {
            return "";
        }
    }

    private static String getComputerId() {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo
                .getHardware();

        ComputerSystem computerSystem = hardwareAbstractionLayer
                .getComputerSystem();
        String uuid = computerSystem.getHardwareUUID();

        CentralProcessor centralProcessor = hardwareAbstractionLayer
                .getProcessor();
        String processorIdentifier = centralProcessor.getProcessorIdentifier()
                .getIdentifier();

        String delimiter = "-";

        return "mid-" + String.format("%08x", uuid.hashCode()) + delimiter
                + String.format("%08x", processorIdentifier.hashCode());
    }

}
