/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.server.Version;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class UsageStatistics {
    private static final ConcurrentHashMap<String, UsageEntry> entries = new ConcurrentHashMap();

    private UsageStatistics() {
    }

    public static void markAsUsed(String name, String version) {
        assert (name != null);
        entries.computeIfAbsent(name, ignore -> new UsageEntry(name, version));
    }

    public static Stream<UsageEntry> getEntries() {
        return entries.values().stream();
    }

    public static void removeEntry(String name) {
        entries.remove(name);
    }

    public static void resetEntries() {
        entries.clear();
        UsageStatistics.setupDefaultEntries();
    }

    private static void setupDefaultEntries() {
        String version = System.getProperty("java.version");
        version = version != null ? version.replaceAll("[-_+].*", "") : "unknown";
        UsageStatistics.markAsUsed("java", version);
    }

    static {
        UsageStatistics.setupDefaultEntries();
    }

    public static class UsageEntry {
        private final String name;
        private final String version;

        private UsageEntry(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            if (this.version == null) {
                return Version.getFullVersion();
            }
            return this.version;
        }
    }
}

