/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.RepeatedAnnotationVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FrontendAnnotatedClassVisitor
extends ClassVisitor {
    private final Map<String, Map<String, Object>> annotationDefaults = new HashMap<String, Map<String, Object>>();
    private final String annotationName;
    private final List<HashMap<String, Object>> data = new ArrayList<HashMap<String, Object>>();
    private final ClassFinder finder;

    FrontendAnnotatedClassVisitor(ClassFinder finder, String annotationName) {
        super(589824);
        this.finder = finder;
        this.annotationName = annotationName;
        if (!this.annotationDefaults.containsKey(annotationName)) {
            this.annotationDefaults.put(annotationName, this.readAnnotationDefaultValues(annotationName));
        }
    }

    public void visitClass(String name) {
        this.visitClass(name, this);
    }

    public void visitClass(String name, ClassVisitor visitor) {
        if (name == null) {
            return;
        }
        try {
            URL url = this.finder.getResource(name.replace(".", "/") + ".class");
            try (InputStream is = url.openStream();){
                ClassReader cr = new ClassReader(is);
                cr.accept(visitor, 0);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.visitClass(superName, this);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        String cname = descriptor.replaceFirst("^L(.*);$", "$1").replace("/", ".");
        if (cname.equals(this.annotationName)) {
            return new DataAnnotationVisitor(this.data, false);
        }
        if (cname.equals(this.annotationName + "$Container")) {
            return new DataAnnotationVisitor(this.data, true);
        }
        return null;
    }

    public <T> Set<T> getValues(String parameter) {
        return this.data.stream().filter(h -> h.containsKey(parameter)).map(h -> h.get(parameter)).collect(Collectors.toSet());
    }

    public <T> Set<T> getValuesForKey(String key, String value, String property) {
        return this.data.stream().filter(h -> h.containsKey(key) && h.get(key).equals(value)).map(h -> h.get(property)).collect(Collectors.toSet());
    }

    public <T> T getValue(String parameter) {
        if (this.data.size() != 1) {
            throw new IllegalArgumentException("getValue can only be used when there is one annotation. There are " + this.data.size() + " instances of " + this.annotationName);
        }
        Set<T> values = this.getValues(parameter);
        if (values.isEmpty()) {
            this.getLogger().debug("No value for {} using default: {}", (Object)parameter, this.getDefault(parameter));
            return this.getDefault(parameter);
        }
        return values.iterator().next();
    }

    private <T> T getDefault(String parameter) {
        return (T)this.annotationDefaults.get(this.annotationName).get(parameter);
    }

    private Map<String, Object> readAnnotationDefaultValues(String annotationName) {
        this.getLogger().debug("Reading default values for {}", (Object)annotationName);
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        this.visitClass(annotationName, new DefaultsAnnotationClassVisitor(this.api, defaults));
        this.getLogger().debug("Default values for {}: {}", (Object)annotationName, defaults);
        return defaults;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(FrontendAnnotatedClassVisitor.class);
    }

    private static class DataAnnotationVisitor
    extends RepeatedAnnotationVisitor {
        private final List<HashMap<String, Object>> data;
        private final boolean isRepeatableContainer;
        private HashMap<String, Object> info = new HashMap();

        DataAnnotationVisitor(List<HashMap<String, Object>> data, boolean isRepeatableContainer) {
            this.data = data;
            this.isRepeatableContainer = isRepeatableContainer;
            data.add(this.info);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if (this.isRepeatableContainer) {
                return this;
            }
            ArrayList values = new ArrayList();
            this.info.put(name, values);
            return new ArrayAnnotationVisitor(this.api, values);
        }

        @Override
        public void visit(String name, Object value) {
            this.info.put(name, value);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            this.info = new HashMap();
            this.data.add(this.info);
            return this;
        }
    }

    private static class DefaultsAnnotationClassVisitor
    extends ClassVisitor {
        private final Map<String, Object> defaults;

        public DefaultsAnnotationClassVisitor(int api, Map<String, Object> defaults) {
            super(api);
            this.defaults = defaults;
        }

        public MethodVisitor visitMethod(int access, String methodName, String descriptor, String signature, String[] exceptions) {
            return new DefaultsAnnotationMethodVisitor(this.api, methodName, this.defaults);
        }
    }

    private static class ArrayAnnotationVisitor
    extends AnnotationVisitor {
        private final List values;

        public ArrayAnnotationVisitor(int api, List values) {
            super(api);
            this.values = values;
        }

        public void visit(String name, Object value) {
            this.values.add(value);
        }
    }

    private static class DefaultsAnnotationVisitor
    extends AnnotationVisitor {
        private final String methodName;
        private final Map<String, Object> defaults;

        public DefaultsAnnotationVisitor(int api, String methodName, Map<String, Object> defaults) {
            super(api);
            this.methodName = methodName;
            this.defaults = defaults;
        }

        public void visit(String name, Object value) {
            this.defaults.put(this.methodName, value);
        }

        public AnnotationVisitor visitArray(String arrayName) {
            ArrayList values = new ArrayList();
            this.defaults.put(this.methodName, values);
            return new ArrayAnnotationVisitor(this.api, values);
        }
    }

    private static class DefaultsAnnotationMethodVisitor
    extends MethodVisitor {
        private final String methodName;
        private final Map<String, Object> defaults;

        public DefaultsAnnotationMethodVisitor(int api, String methodName, Map<String, Object> defaults) {
            super(api);
            this.methodName = methodName;
            this.defaults = defaults;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new DefaultsAnnotationVisitor(this.api, this.methodName, this.defaults);
        }
    }
}

