/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.VaadinRequestInterceptor;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class ServiceInitEvent
extends EventObject {
    private List<RequestHandler> addedRequestHandlers = new ArrayList<RequestHandler>();
    private List<IndexHtmlRequestListener> addedIndexHtmlRequestListeners = new ArrayList<IndexHtmlRequestListener>();
    private List<DependencyFilter> addedDependencyFilters = new ArrayList<DependencyFilter>();
    private List<VaadinRequestInterceptor> addedVaadinRequestInterceptors = new ArrayList<VaadinRequestInterceptor>();

    public ServiceInitEvent(VaadinService service) {
        super(service);
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        Objects.requireNonNull(requestHandler, "Request handler cannot be null");
        this.addedRequestHandlers.add(requestHandler);
    }

    public void addIndexHtmlRequestListener(IndexHtmlRequestListener indexHtmlRequestListener) {
        Objects.requireNonNull(indexHtmlRequestListener, "Index HTML request listener cannot be null");
        this.addedIndexHtmlRequestListeners.add(indexHtmlRequestListener);
    }

    public void addDependencyFilter(DependencyFilter dependencyFilter) {
        Objects.requireNonNull(dependencyFilter, "Dependency filter cannot be null");
        this.addedDependencyFilters.add(dependencyFilter);
    }

    public void addVaadinRequestInterceptor(VaadinRequestInterceptor vaadinRequestInterceptor) {
        Objects.requireNonNull(vaadinRequestInterceptor, "Request Interceptor cannot be null");
        this.addedVaadinRequestInterceptors.add(vaadinRequestInterceptor);
    }

    public Stream<RequestHandler> getAddedRequestHandlers() {
        return this.addedRequestHandlers.stream();
    }

    public Stream<IndexHtmlRequestListener> getAddedIndexHtmlRequestListeners() {
        return this.addedIndexHtmlRequestListeners.stream();
    }

    public Stream<DependencyFilter> getAddedDependencyFilters() {
        return this.addedDependencyFilters.stream();
    }

    public Stream<VaadinRequestInterceptor> getAddedVaadinRequestInterceptor() {
        return this.addedVaadinRequestInterceptors.stream();
    }

    @Override
    public VaadinService getSource() {
        return (VaadinService)super.getSource();
    }
}

