/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.RouteResolver;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.ResolveRequest;
import com.vaadin.flow.server.RouteRegistry;
import org.slf4j.LoggerFactory;

public class DefaultRouteResolver
implements RouteResolver {
    @Override
    public NavigationState resolve(ResolveRequest request) {
        String path;
        RouteRegistry registry = request.getRouter().getRegistry();
        NavigationRouteTarget navigationResult = registry.getNavigationRouteTarget(path = request.getLocation().getPath());
        if (!navigationResult.hasTarget()) {
            return null;
        }
        NavigationStateBuilder builder = new NavigationStateBuilder(request.getRouter());
        try {
            builder.withTarget(navigationResult.getRouteTarget(), navigationResult.getRouteParameters());
            builder.withPath(navigationResult.getPath());
        }
        catch (NotFoundException nfe) {
            String message = "Exception while navigation to path " + path;
            LoggerFactory.getLogger((String)this.getClass().getName()).warn(message, (Throwable)nfe);
            throw nfe;
        }
        return builder.build();
    }
}

