/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.external.apache.commons.fileupload2.jaksrvlt;

import com.vaadin.external.apache.commons.fileupload2.UploadContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;

public class JakSrvltRequestContext
implements UploadContext {
    private final HttpServletRequest request;

    public JakSrvltRequestContext(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    @Override
    public String getContentType() {
        return this.request.getContentType();
    }

    @Override
    @Deprecated
    public int getContentLength() {
        return this.request.getContentLength();
    }

    @Override
    public long contentLength() {
        long size;
        try {
            size = Long.parseLong(this.request.getHeader("Content-length"));
        }
        catch (NumberFormatException e) {
            size = this.request.getContentLength();
        }
        return size;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public String toString() {
        return String.format("ContentLength=%s, ContentType=%s", this.contentLength(), this.getContentType());
    }
}

