/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter.custom;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.InsertionPoint;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.copilot.javarewriter.custom.CustomComponentHandle;
import java.util.List;
import java.util.Map;

public class DetailsComponentHandle
extends CustomComponentHandle {
    private static final String SUMMARY = "summary";
    private static final String SUMMARY_TEXT = "text";

    @Override
    public List<VariableDeclarator> createComponentStatements(JavaRewriter javaRewriter, JavaComponent component, InsertionPoint insertionPoint, JavaComponent parent, String layoutVariableName, ComponentInfo referenceComponent, JavaRewriter.AddTemplateOptions options) {
        String componentClassName = FlowComponentQuirks.getClassForComponent(component);
        ClassOrInterfaceType fullType = StaticJavaParser.parseClassOrInterfaceType((String)componentClassName);
        JavaRewriterUtil.addImport(javaRewriter.getCompilationUnit(), fullType.getNameWithScope());
        String detailsVariableName = JavaRewriterUtil.generateVariableName(component, fullType, insertionPoint);
        VariableDeclarator detailsVarDeclarator = new VariableDeclarator((Type)fullType.removeScope(), detailsVariableName);
        ObjectCreationExpr detailsCreationExpr = new ObjectCreationExpr();
        detailsCreationExpr.setType(fullType.removeScope());
        Map<String, Object> props = component.props();
        if (props.containsKey(SUMMARY)) {
            detailsCreationExpr.addArgument((Expression)new StringLiteralExpr((String)props.get(SUMMARY)));
        }
        detailsVarDeclarator.setInitializer((Expression)detailsCreationExpr);
        VariableDeclarationExpr detailsVarDeclaration = new VariableDeclarationExpr(detailsVarDeclarator);
        insertionPoint.add((Statement)new ExpressionStmt((Expression)detailsVarDeclaration));
        if (props.containsKey(SUMMARY_TEXT)) {
            MethodCallExpr methodCallExpr = new MethodCallExpr("add", new Expression[0]);
            methodCallExpr.setScope((Expression)new NameExpr(detailsVariableName));
            methodCallExpr.addArgument((Expression)new StringLiteralExpr((String)props.get(SUMMARY_TEXT)));
            insertionPoint.add((Statement)new ExpressionStmt((Expression)methodCallExpr));
            this.addOpenedMethodCall(detailsVariableName, insertionPoint);
        }
        this.insertSetter(component, detailsCreationExpr, javaRewriter, componentClassName, insertionPoint, new NameExpr(detailsVariableName));
        if (!component.children().isEmpty()) {
            javaRewriter.createComponentStatements(insertionPoint, component, component.children(), detailsVariableName, null, options);
            this.addOpenedMethodCall(detailsVariableName, insertionPoint);
        }
        javaRewriter.attachComponent(insertionPoint, component, parent, layoutVariableName, referenceComponent, (Expression)new NameExpr(detailsVariableName), detailsVariableName);
        return List.of(detailsVarDeclarator);
    }

    @Override
    protected boolean skipProps(JavaComponent component, String prop) {
        return super.skipProps(component, prop) || prop.equals(SUMMARY) || prop.equals(SUMMARY_TEXT);
    }

    private void addOpenedMethodCall(String detailsVariableName, InsertionPoint insertionPoint) {
        MethodCallExpr openExpression = new MethodCallExpr("setOpened", new Expression[0]);
        openExpression.setScope((Expression)new NameExpr(detailsVariableName));
        openExpression.addArgument((Expression)new BooleanLiteralExpr(true));
        insertionPoint.add((Statement)new ExpressionStmt((Expression)openExpression));
    }
}

