/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter.custom;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithArguments;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.InsertionPoint;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.copilot.javarewriter.custom.CustomComponentHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CrudComponentHandle
extends CustomComponentHandle {
    @Override
    public List<VariableDeclarator> createComponentStatements(JavaRewriter javaRewriter, JavaComponent component, InsertionPoint insertionPoint, JavaComponent parent, String layoutVariableName, ComponentInfo referenceComponent, JavaRewriter.AddTemplateOptions options) {
        String componentClassName = FlowComponentQuirks.getClassForComponent(component);
        ClassOrInterfaceType fullType = StaticJavaParser.parseClassOrInterfaceType((String)componentClassName);
        JavaRewriterUtil.addImport(javaRewriter.getCompilationUnit(), fullType.getNameWithScope());
        javaRewriter.addImport("com.vaadin.flow.component.crud.BinderCrudEditor", false, false);
        javaRewriter.addImport("com.vaadin.flow.data.binder.Binder", false, false);
        JavaComponent grid = component.withTag("Grid");
        List<VariableDeclarator> gridDeclaration = javaRewriter.createComponentStatements(insertionPoint, parent, grid, false, layoutVariableName, referenceComponent, options);
        if (gridDeclaration.isEmpty()) {
            throw new IllegalArgumentException("Could not generate Grid for the Crud component");
        }
        VariableDeclarator gridVariableDeclarator = gridDeclaration.get(0);
        String gridVariableName = gridVariableDeclarator.getNameAsString();
        String crudVariableName = JavaRewriterUtil.getNewComponentName(component, fullType, insertionPoint);
        ClassExpr beanClassExpression = this.getBeanClassExpressionFromGrid(gridVariableDeclarator);
        fullType.setTypeArguments(new Type[]{beanClassExpression.getType()});
        VariableDeclarator decl = new VariableDeclarator((Type)fullType.removeScope(), crudVariableName);
        ObjectCreationExpr expr = new ObjectCreationExpr();
        expr.setType("Crud");
        ClassOrInterfaceType toDeleteType = new ClassOrInterfaceType();
        toDeleteType.setName("DELETE_THIS");
        expr.getType().setTypeArguments(new Type[]{toDeleteType});
        decl.setInitializer((Expression)expr);
        expr.getArguments().add((Node)beanClassExpression);
        expr.getArguments().add((Node)new NameExpr(gridVariableName));
        expr.getArguments().add((Node)new NameExpr("new BinderCrudEditor<>(new Binder<>())"));
        VariableDeclarationExpr declarationExpr = new VariableDeclarationExpr(decl);
        insertionPoint.add((Statement)new ExpressionStmt((Expression)declarationExpr));
        javaRewriter.attachComponent(insertionPoint, component, parent, layoutVariableName, referenceComponent, (Expression)new NameExpr(crudVariableName), crudVariableName);
        return new ArrayList<VariableDeclarator>();
    }

    private ClassExpr getBeanClassExpressionFromGrid(VariableDeclarator declarator) {
        Expression expression;
        Optional initializer = declarator.getInitializer();
        if (initializer.isPresent() && (expression = (Expression)initializer.get()) instanceof NodeWithArguments) {
            NodeWithArguments nodeWithArguments = (NodeWithArguments)expression;
            for (Expression argument : nodeWithArguments.getArguments()) {
                if (!(argument instanceof ClassExpr)) continue;
                ClassExpr classExpr = (ClassExpr)argument;
                return classExpr;
            }
        }
        throw new IllegalArgumentException("Unable to locate bean type of the grid");
    }
}

