/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.CopilotException;
import com.vaadin.flow.server.VaadinServletContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class SpringBridge {
    public static boolean isSpringAvailable() {
        try {
            Class.forName("org.springframework.web.context.WebApplicationContext");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String getPropertyValue(VaadinServletContext context, String property) {
        return (String)SpringBridge.call("getPropertyValue", context, property);
    }

    private static Object call(String methodName, Object ... parameters) {
        try {
            Method method = Arrays.stream(SpringBridge.getIntegration().getMethods()).filter(m -> {
                if (!m.getName().equals(methodName)) {
                    return false;
                }
                return parameters == null || parameters.length == m.getParameterCount();
            }).findFirst().orElseThrow(NoSuchMethodException::new);
            return method.invoke(null, parameters);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CopilotException(e);
        }
    }

    private static Class<?> getIntegration() throws ClassNotFoundException {
        return Class.forName("com.vaadin.copilot.SpringIntegration");
    }

    public static Class<?> getApplicationClass(VaadinServletContext context) {
        return (Class)SpringBridge.call("getApplicationClass", context);
    }

    public static boolean isViewSecurityEnabled(VaadinServletContext context) {
        return SpringBridge.call("isViewSecurityEnabled", context) == Boolean.TRUE;
    }

    public static String getUrlPrefix(VaadinServletContext context) {
        String value = SpringBridge.getPropertyValue(context, "vaadin.url-mapping");
        if (value == null) {
            return "";
        }
        if (value.endsWith("/*")) {
            value = value.substring(0, value.length() - 2);
        }
        if (value.endsWith("/")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static List<EndpointInfo> getEndpoints(VaadinServletContext context) {
        return (List)SpringBridge.call("getEndpoints", context);
    }

    public record EndpointInfo(Class<?> endpointClass, Method method) {
    }
}

