package com.vaadin.copilot.plugins.themeeditor;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

import com.vaadin.copilot.ComponentSourceFinder;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;

/** Editor extension to use ProjectManager to write file content */
public class CopilotEditor extends Editor {

    private static final String COPILOT_FILE_UPDATE_UNDO_LABEL = CopilotIDEPlugin.undoLabel("File Update");

    protected final ProjectManager projectManager;
    protected final ComponentSourceFinder sourceFinder;

    public CopilotEditor(ProjectManager projectManager) {
        this.projectManager = projectManager;
        this.sourceFinder = new ComponentSourceFinder(projectManager);
    }

    @Override
    public int modifyClass(File f, Function<CompilationUnit, List<Modification>> modifier) {
        try {
            String source = projectManager.readFile(f);
            CompilationUnit cu = this.parseSource(source);
            List<Modification> mods = modifier.apply(cu);
            Collections.sort(mods);
            int sourceOffset = 0;

            Modification mod;
            for (Iterator var7 = mods.iterator(); var7.hasNext(); sourceOffset += mod.sourceOffset()) {
                mod = (Modification) var7.next();
                mod.apply();
            }

            String newSource = LexicalPreservingPrinter.print(cu);
            if (newSource.equals(source)) {
                throw new UnsupportedOperationException("Unable to edit file");
            } else {
                projectManager.writeFile(f, COPILOT_FILE_UPDATE_UNDO_LABEL, newSource);
                return sourceOffset;
            }
        } catch (IOException var13) {
            throw new UnsupportedOperationException(var13);
        }
    }
}
