package com.vaadin.copilot.ide;

import elemental.json.Json;
import elemental.json.JsonObject;

public record IdeNotification(String message, Type type, String dismissId) {

    public enum Type {
        INFORMATION, WARNING, ERROR

    }

    public JsonObject asJson() {
        JsonObject object = Json.createObject();
        object.put("message", message);
        object.put("type", type.name());
        object.put("dismissId", dismissId);
        return object;
    }
}
