/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.testgeneration;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.FlowUtil;
import com.vaadin.copilot.JavaSourcePathDetector;
import com.vaadin.copilot.ProjectFileManager;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ai.AICommunicationUtil;
import com.vaadin.copilot.plugins.testgeneration.TestGenerationServerClient;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.router.Route;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.uitest.TestCodeGenerator;
import com.vaadin.uitest.ai.utils.PromptUtils;
import com.vaadin.uitest.model.TestFramework;
import com.vaadin.uitest.model.UiRoute;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateTestsHandler
implements CopilotCommand {
    private static final String GENERATE_TESTS_COMMAND = "generate-tests";
    private static final String RESPONSE_ERROR_KEY = "error";
    private static final String RESPONSE_TEST_GENERATION_RESULT_SUMMARY_KEY = "testGenerationResultSummary";
    private static final String RESPONSE_TEST_GENERATION_GENERATED_FILE_KEY = "testGenerationResultFile";
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateTestsHandler.class);
    private final ProjectManager projectManager;
    private final TestGenerationServerClient client = new TestGenerationServerClient();

    public GenerateTestsHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (!GENERATE_TESTS_COMMAND.equals(command)) {
            return false;
        }
        ProKey proKey = GenerateTestsHandler.getProKey();
        String machineId = this.getMachineId();
        if (proKey == null && machineId == null) {
            AICommunicationUtil.promptTextCannotCall(data, devToolsInterface);
            return true;
        }
        UiRoute route = this.getRoute(data, devToolsInterface);
        if (route == null) {
            throw new IllegalArgumentException("Route cannot be processed, as reference here is the received data: \n" + JsonUtil.stringify((JsonValue)data, (int)2));
        }
        JsonObject respData = Json.createObject();
        respData.put("reqId", data.getString("reqId"));
        respData.put(RESPONSE_TEST_GENERATION_GENERATED_FILE_KEY, route.getTestfile());
        LOGGER.info("Generating '{}' tests for route: '/{}', file '{}'", new Object[]{route.getFramework(), route.getRoute() == null ? "" : route.getRoute(), route.getTestfile()});
        try {
            String generatedTestSource = this.client.generateTests(proKey, machineId, route, null);
            TestCodeGenerator.writeUiTest((UiRoute)route, (String)generatedTestSource);
            String summary = TestCodeGenerator.addTestDependencies((UiRoute)route, (String)this.projectManager.getProjectRoot().getPath(), (String)GenerateTestsHandler.getTestFolder(route).toString()) ? "Test generated and dependencies updated." : "Test generation successful.";
            respData.put(RESPONSE_TEST_GENERATION_RESULT_SUMMARY_KEY, summary);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("Failed to generate tests", (Throwable)e);
            respData.put(RESPONSE_ERROR_KEY, "Failed to generate tests. See the server log for more details");
        }
        devToolsInterface.send(command + "-response", respData);
        return true;
    }

    private UiRoute getRoute(JsonObject data, DevToolsInterface devToolsInterface) {
        ArrayList<UiRoute> sources = new ArrayList<UiRoute>(this.getHillaSources(data));
        try {
            sources.addAll(this.getJavaSources(data));
        }
        catch (IOException e) {
            LOGGER.error("Error reading requested project Flow Java files", (Throwable)e);
            devToolsInterface.send("copilot-prompt-failed", Json.createObject());
            return null;
        }
        sources.forEach(s -> s.setSource(PromptUtils.cleanJavaCode((String)s.getSource())));
        String path = this.getPath(data);
        UiRoute view = sources.stream().filter(s -> s.getRoute() != null && s.getRoute().equals(path)).findFirst().orElse((UiRoute)sources.get(sources.size() - 1));
        if (view.getRoute() == null) {
            view.setRoute(path);
        }
        view.setRoute(this.getPath(data));
        view.setHtml(this.getHtml(data));
        view.setBaseUrl(this.getBaseUrl(data));
        TestFramework fw = "flow".equals(view.getFramework()) ? TestFramework.PLAYWRIGHT_JAVA : TestFramework.PLAYWRIGHT_NODE;
        Path javaTestDir = GenerateTestsHandler.getTestFolder(view);
        view.computeTestName(javaTestDir.toFile(), fw);
        File testFile = new File(view.getTestfile());
        if (testFile.isAbsolute()) {
            view.setTestfile(this.projectManager.getProjectRelativeName(testFile));
        }
        view.setProjectRoot(this.projectManager.getProjectRoot().getAbsolutePath());
        return view;
    }

    private static Path getTestFolder(UiRoute view) {
        File viewFile;
        File referenceFile;
        ProjectFileManager projectFileManager = ProjectFileManager.getInstance();
        Optional<JavaSourcePathDetector.ModuleInfo> module = projectFileManager.findModule(referenceFile = (viewFile = new File(view.getFile())).exists() ? viewFile : projectFileManager.getFileForClass(view.getClassName()));
        Optional javaTestDir = module.flatMap(JavaSourcePathDetector.ModuleInfo::getOrGuessTestFolder);
        if (javaTestDir.isEmpty()) {
            throw new IllegalStateException("Unable to determine the test folder for the module");
        }
        return (Path)javaTestDir.get();
    }

    private String getPath(JsonObject data) {
        if (!data.hasKey("path")) {
            return null;
        }
        return data.getString("path");
    }

    private String getBaseUrl(JsonObject data) {
        if (!data.hasKey("base")) {
            return null;
        }
        return data.getString("base");
    }

    private String getHtml(JsonObject data) {
        if (!data.hasKey("html")) {
            return null;
        }
        return PromptUtils.cleanHtml((String)data.getString("html"));
    }

    private List<UiRoute> getHillaSources(JsonObject data) {
        Map<String, String> hillaSourceFiles = AICommunicationUtil.getHillaSourceFiles(data);
        return hillaSourceFiles.entrySet().stream().map(e -> {
            UiRoute route = new UiRoute();
            route.setFile((String)e.getKey());
            route.getFramework();
            route.setClassName(FilenameUtils.getBaseName((String)((String)e.getKey())));
            route.setSource((String)e.getValue());
            return route;
        }).toList();
    }

    private List<UiRoute> getJavaSources(JsonObject data) throws IOException {
        if (!data.hasKey("uiid")) {
            return Collections.emptyList();
        }
        ArrayList<UiRoute> sources = new ArrayList<UiRoute>();
        for (Map.Entry<ComponentTracker.Location, File> entry : FlowUtil.findActiveJavaFiles(this.projectManager, (int)data.getNumber("uiid")).entrySet()) {
            ComponentTracker.Location location = entry.getKey();
            File javaFile = entry.getValue();
            UiRoute route = new UiRoute();
            route.setFile(location.filename());
            route.getFramework();
            route.setClassName(location.className());
            route.setRoute(this.getAnnotationValue(location.className(), Route.class));
            route.setTagName(this.getAnnotationValue(location.className(), Tag.class));
            route.setSource(this.projectManager.readFile(javaFile.getPath()));
            sources.add(route);
        }
        return sources;
    }

    public String getAnnotationValue(String className, Class<? extends Annotation> annotationClass) {
        try {
            for (Class<?> clazz = Class.forName(className); clazz != null; clazz = clazz.getSuperclass()) {
                if (!clazz.isAnnotationPresent(annotationClass)) continue;
                Annotation annotation = clazz.getAnnotation(annotationClass);
                Method valueMethod = annotationClass.getMethod("value", new Class[0]);
                return (String)valueMethod.invoke((Object)annotation, new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting annotation value: {} - Class: {} - Annotation: {}", new Object[]{e.getMessage(), className, annotationClass.getName()});
        }
        return null;
    }

    private static ProKey getProKey() {
        return LocalProKey.get();
    }

    String getMachineId() {
        return MachineId.get();
    }
}

