/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;

public class InsertionPoint {
    private final BlockStmt block;
    private final ClassOrInterfaceDeclaration declaration;
    private int index;

    public InsertionPoint(BlockStmt block, int index) {
        this.block = block;
        this.index = index;
        this.declaration = null;
    }

    public InsertionPoint(ClassOrInterfaceDeclaration declaration, int index) {
        this.declaration = declaration;
        this.index = index;
        this.block = null;
    }

    public String getFreeVariableName(String baseName) {
        if (this.getBlock() != null) {
            return JavaRewriterUtil.findFreeVariableName(baseName, this.getBlock());
        }
        if (this.getDeclaration() != null) {
            return JavaRewriterUtil.findFreeVariableName(baseName, this.getDeclaration());
        }
        return null;
    }

    public void add(Statement statement) {
        if (this.block == null) {
            throw new IllegalArgumentException("Cannot add statement to a class or interface declaration");
        }
        this.block.addStatement(this.index++, statement);
    }

    public void incrementIndex(int increment) {
        this.index += increment;
    }

    public void incrementIndexByOne() {
        this.incrementIndex(1);
    }

    public BlockStmt getBlock() {
        return this.block;
    }

    public int getIndex() {
        return this.index;
    }

    public ClassOrInterfaceDeclaration getDeclaration() {
        return this.declaration;
    }
}

