/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.vaadin.copilot.javarewriter.InsertionPoint;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.shared.util.SharedUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public final class FlowComponentQuirks {
    public static final String CHART_TYPE = "com.vaadin.flow.component.charts.model.ChartType";
    private static final String AVATAR_GROUP = "com.vaadin.flow.component.avatar.AvatarGroup";
    private static final String AVATAR_GROUP_ITEM = "com.vaadin.flow.component.avatar.AvatarGroup.AvatarGroupItem";
    private static final String MESSAGE_LIST = "com.vaadin.flow.component.messages.MessageList";
    private static final String MESSAGE_LIST_ITEM = "com.vaadin.flow.component.messages.MessageListItem";
    private static final String CHARTS_DATA_SERIES = "com.vaadin.flow.component.charts.model.DataSeries";
    private static final String CHARTS_LIST_SERIES = "com.vaadin.flow.component.charts.model.ListSeries";
    private static final String CHARTS_DATA_SERIES_ITEM = "com.vaadin.flow.component.charts.model.DataSeriesItem";
    private static final String GRID_TREE_COLUMN = "GridTreeColumn";
    private static final String GRID_COLUMN = "GridColumn";
    private static final String GRID_SELECTION_COLUMN = "GridSelectionColumn";
    private static final String GRID_SORT_COLUMN = "GridSortColumn";
    private static final String ITEMS = "items";
    private static final String TAB_SHEET_TAB = "TabSheetTab";
    private static final String MENU_ITEM = "MenuItem";
    private static final String SUB_MENU = "SubMenu";

    private FlowComponentQuirks() {
    }

    public static String getClassForComponent(JavaComponent javaComponent) {
        String[] probes;
        String tag = javaComponent.tag();
        if (javaComponent.children().stream().anyMatch(c -> c.tag().equalsIgnoreCase(GRID_TREE_COLUMN))) {
            tag = "TreeGrid";
        }
        if (tag.equalsIgnoreCase("A")) {
            tag = "Anchor";
        } else if (tag.equalsIgnoreCase("P")) {
            tag = "Paragraph";
        } else if (tag.equalsIgnoreCase("OL")) {
            tag = "OrderedList";
        } else if (tag.equalsIgnoreCase("ul")) {
            tag = "UnorderedList";
        } else if (tag.equalsIgnoreCase("dl")) {
            tag = "DescriptionList";
        } else if (tag.equalsIgnoreCase("dt")) {
            tag = "DescriptionList.Term";
        } else if (tag.equalsIgnoreCase("dd")) {
            tag = "DescriptionList.Description";
        } else if (tag.equalsIgnoreCase("LI")) {
            tag = "ListItem";
        } else if (tag.equalsIgnoreCase("img")) {
            tag = "Image";
        }
        String capitalizedTag = SharedUtil.capitalize((String)tag);
        String lowercaseTag = tag.toLowerCase(Locale.ENGLISH);
        String lowercaseFirstPart = FlowComponentQuirks.removeInitialDash(SharedUtil.camelCaseToDashSeparated((String)tag)).split("-", 2)[0].toLowerCase(Locale.ENGLISH);
        for (String probe : probes = new String[]{"com.vaadin.flow.component.html." + capitalizedTag, "com.vaadin.flow.component." + lowercaseTag + "." + capitalizedTag, "com.vaadin.flow.component." + lowercaseFirstPart + "." + capitalizedTag, "com.vaadin.flow.component.orderedlayout." + capitalizedTag, "com.vaadin.flow.component.messages." + capitalizedTag, "com.vaadin.flow.component.sidenav." + capitalizedTag, "com.vaadin.flow.component.textfield." + capitalizedTag, "com.vaadin.flow.component.combobox." + capitalizedTag, "com.vaadin.flow.component.applayout." + capitalizedTag, "com.vaadin.flow.component.charts." + capitalizedTag, "com.vaadin.flow.component.tabs." + capitalizedTag, "com.vaadin.flow.component.grid." + capitalizedTag, "com.vaadin.flow.component.treegrid." + capitalizedTag}) {
            if (!FlowComponentQuirks.exists(probe)) continue;
            return probe;
        }
        if (tag.equalsIgnoreCase("BoardRow")) {
            return "com.vaadin.flow.component.board.Row";
        }
        if (tag.equalsIgnoreCase("RadioGroup")) {
            return "com.vaadin.flow.component.radiobutton.RadioButtonGroup";
        }
        if (tag.equalsIgnoreCase("ChartSeries") && javaComponent.props().containsKey("values")) {
            List values = (List)javaComponent.props().get("values");
            if (!values.isEmpty() && (values.get(0) instanceof Map || values.get(0) instanceof List)) {
                return CHARTS_DATA_SERIES;
            }
            return CHARTS_LIST_SERIES;
        }
        throw new IllegalArgumentException("Unable to find Java class for <" + tag + ">");
    }

    private static String removeInitialDash(String s) {
        if (s.startsWith("-")) {
            return s.substring(1);
        }
        return s;
    }

    private static boolean exists(String className) {
        try {
            JavaRewriterUtil.getClass(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object componentSpecificValueMapping(Class<?> componentType, String prop, Object value) {
        String itemType = FlowComponentQuirks.getListSetterType(componentType, prop);
        if (itemType != null) {
            List itemList;
            Object firstItem;
            if (value instanceof Map && ((Map)value).containsKey("object")) {
                value = ((Map)value).get("object");
            }
            Object v0 = firstItem = (itemList = (List)value).isEmpty() ? null : itemList.get(0);
            if (firstItem instanceof Map) {
                return FlowComponentQuirks.mapToClass(itemList, itemType, null);
            }
            if (firstItem instanceof List) {
                return itemList.stream().map(item -> {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("x", item.get(0));
                    props.put("y", item.get(1));
                    return new JavaComponent(null, itemType, props, new ArrayList<JavaComponent>());
                }).toList();
            }
        }
        return value;
    }

    private static String getListSetterType(Class<?> componentType, String prop) {
        if (componentType.getName().equals(AVATAR_GROUP) && prop.equals(ITEMS)) {
            return AVATAR_GROUP_ITEM;
        }
        if (componentType.getName().equals(MESSAGE_LIST) && prop.equals(ITEMS)) {
            return MESSAGE_LIST_ITEM;
        }
        if (componentType.getName().equals(CHARTS_DATA_SERIES) && prop.equals("values")) {
            return CHARTS_DATA_SERIES_ITEM;
        }
        return null;
    }

    private static List<JavaComponent> mapToClass(List<Map<String, Object>> value, String itemClass, BiFunction<String, Object, Object> customMapper) {
        return value.stream().map(item -> {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (Map.Entry entry : item.entrySet()) {
                Object propValue = entry.getValue();
                String property = (String)entry.getKey();
                if (property.equals("z")) continue;
                if (customMapper != null) {
                    propValue = customMapper.apply(property, propValue);
                }
                props.put(property, propValue);
            }
            return new JavaComponent(null, itemClass, props, new ArrayList<JavaComponent>());
        }).toList();
    }

    public static String convertReactPropertyToJavaSetter(String property, Class<?> type) {
        if (property.equals("theme")) {
            if (JavaRewriterUtil.hasMethod(type, "setThemeName")) {
                return "setThemeName";
            }
            return "getElement().getThemeList().add";
        }
        String typeName = type.getName();
        if (property.equals("checked") && typeName.equals("com.vaadin.flow.component.checkbox.Checkbox")) {
            return "setValue";
        }
        if (property.equals("text") && (typeName.equals("com.vaadin.flow.component.tabs.Tab") || typeName.equals("com.vaadin.flow.component.sidenav.SideNavItem"))) {
            return "setLabel";
        }
        if (property.equals("summary") && (typeName.equals("com.vaadin.flow.component.accordion.AccordionPanel") || typeName.equals("com.vaadin.flow.component.details.Details"))) {
            return "setSummaryText";
        }
        if (property.equals("img") && typeName.equals("com.vaadin.flow.component.avatar.Avatar")) {
            return "setImage";
        }
        if (property.equals("img") && typeName.equals("com.vaadin.flow.component.avatar.AvatarGroup$AvatarGroupItem")) {
            return "setImage";
        }
        if (property.equals("abbr") && (typeName.equals("com.vaadin.flow.component.avatar.Avatar") || typeName.equals("com.vaadin.flow.component.avatar.AvatarGroup$AvatarGroupItem"))) {
            return "setAbbreviation";
        }
        if (property.equals("userAbbr") && typeName.equals(MESSAGE_LIST_ITEM)) {
            return "setUserAbbreviation";
        }
        if (property.equals("nodrop") && typeName.equals("com.vaadin.flow.component.upload.Upload")) {
            return "setDropAllowed";
        }
        if (property.equals("dataProvider")) {
            return "setItems";
        }
        if (property.equals(ITEMS) && typeName.equals("com.vaadin.flow.component.menubar.MenuBar")) {
            return "addItem";
        }
        if (property.equals("values") && typeName.equals(CHARTS_LIST_SERIES)) {
            return "setData";
        }
        if (property.equals("values") && typeName.equals(CHARTS_DATA_SERIES)) {
            return "setData";
        }
        if (property.equals("title") && (typeName.equals(CHARTS_LIST_SERIES) || typeName.equals(CHARTS_DATA_SERIES))) {
            return "setName";
        }
        if (property.equals("type") && typeName.equals(CHARTS_LIST_SERIES)) {
            return "setPlotOptions";
        }
        return null;
    }

    public static boolean isInvertedBoolean(String property, Class<?> type) {
        return property.equals("nodrop") && type.getName().equals("com.vaadin.flow.component.upload.Upload");
    }

    public static boolean childrenGeneratesData(JavaComponent parent, JavaComponent child) {
        if ("ListBox".equals(parent.tag()) && "Item".equals(child.tag())) {
            return true;
        }
        if ("RadioGroup".equals(parent.tag()) && "RadioButton".equals(child.tag())) {
            return true;
        }
        return "CheckboxGroup".equals(parent.tag()) && "Checkbox".equals(child.tag());
    }

    public static boolean hasSetItemsProps(JavaComponent component) {
        if (!component.props().containsKey(ITEMS) && !component.props().containsKey("dataProvider")) {
            return false;
        }
        return FlowComponentQuirks.hasSetItemsMethod(component);
    }

    public static boolean hasSetItemsMethod(JavaComponent component) {
        return component.tag() != null && Set.of("Select", "ComboBox", "MultiSelectComboBox", "Grid", "TreeGrid").contains(component.tag());
    }

    public static boolean skipProps(JavaComponent component, String propKey) {
        if ("ListBox".equals(component.tag()) && propKey.equals("selected")) {
            return true;
        }
        if ("Message".equals(component.tag()) && propKey.equals("className")) {
            return true;
        }
        if (propKey.equals("slot")) {
            return true;
        }
        if (propKey.equals("stacking") && "Chart".equals(component.tag())) {
            return true;
        }
        return FlowComponentQuirks.hasSetItemsProps(component) && (propKey.equals(ITEMS) || propKey.equals("dataProvider"));
    }

    public static List<JavaComponent> getMethodCallChildren(JavaComponent javaComponent) {
        ArrayList<JavaComponent> methodCallChildren = new ArrayList<JavaComponent>();
        if (javaComponent.tag() != null && (javaComponent.tag().equalsIgnoreCase("Grid") || javaComponent.tag().equalsIgnoreCase("TreeGrid"))) {
            methodCallChildren.addAll(javaComponent.children().stream().map(child -> {
                if (child.tag() != null && (FlowComponentQuirks.isGridColumnDefinition(child) || FlowComponentQuirks.isGridColumnAttribute(child))) {
                    return child;
                }
                return null;
            }).toList());
        }
        return methodCallChildren;
    }

    public static String getSetterNameFromComponent(JavaComponent child) {
        if (child == null || child.tag() == null) {
            return null;
        }
        if (child.tag().equalsIgnoreCase(GRID_SORT_COLUMN)) {
            return "setSortable";
        }
        if (child.tag().equals(GRID_SELECTION_COLUMN)) {
            return "setSelectionMode";
        }
        return null;
    }

    public static List<MethodCallExpr> getMethodCallExprFromComponent(CompilationUnit compilationUnit, JavaComponent child, Expression owner, String dataEntityRecordName) {
        ArrayList<MethodCallExpr> expressions = new ArrayList<MethodCallExpr>();
        if (child == null || child.tag() == null) {
            return expressions;
        }
        if (FlowComponentQuirks.isGridColumnDefinition(child)) {
            MethodReferenceExpr methodReference = new MethodReferenceExpr();
            methodReference.setScope((Expression)new NameExpr(dataEntityRecordName));
            methodReference.setIdentifier(child.props().get("path").toString());
            MethodCallExpr expression = child.tag().equalsIgnoreCase(GRID_TREE_COLUMN) ? ((MethodCallExpr)new MethodCallExpr(owner, "addHierarchyColumn").addArgument((Expression)methodReference)).asMethodCallExpr() : ((MethodCallExpr)new MethodCallExpr(owner, "addColumn").addArgument((Expression)methodReference)).asMethodCallExpr();
            MethodCallExpr expressionHeader = ((MethodCallExpr)new MethodCallExpr((Expression)expression, "setHeader").addArgument((Expression)new StringLiteralExpr(child.props().get("path").toString()))).asMethodCallExpr();
            expressions.add(expressionHeader);
        } else if (FlowComponentQuirks.isGridColumnAttribute(child) && child.tag().equalsIgnoreCase(GRID_SELECTION_COLUMN)) {
            FieldAccessExpr selectionModeExpr = new FieldAccessExpr((Expression)new FieldAccessExpr((Expression)new NameExpr("Grid"), "SelectionMode"), "MULTI");
            expressions.add(((MethodCallExpr)new MethodCallExpr(owner, "setSelectionMode").addArgument((Expression)selectionModeExpr)).asMethodCallExpr());
            String lambdaString = "selection -> {\n    System.out.printf(\"Number of selected people: %s%n\",\n    selection.getAllSelectedItems().size());\n}";
            LambdaExpr lambdaExpr = StaticJavaParser.parseExpression((String)lambdaString).asLambdaExpr();
            expressions.add(((MethodCallExpr)new MethodCallExpr(owner, "addSelectionListener").addArgument((Expression)lambdaExpr)).asMethodCallExpr());
        }
        return expressions;
    }

    public static boolean isGridColumnDefinition(JavaComponent component) {
        return component.tag() != null && (component.tag().equalsIgnoreCase(GRID_COLUMN) || component.tag().equalsIgnoreCase(GRID_SORT_COLUMN) || component.tag().equalsIgnoreCase(GRID_TREE_COLUMN));
    }

    public static boolean isGridTreeColumnDefinition(JavaComponent component) {
        return component.tag() != null && component.tag().equalsIgnoreCase(GRID_TREE_COLUMN);
    }

    public static boolean isGridColumnAttribute(JavaComponent component) {
        return component.tag() != null && component.tag().equalsIgnoreCase(GRID_SELECTION_COLUMN);
    }

    public static boolean isTabSheetDefinition(JavaComponent component) {
        return component.tag() != null && component.tag().equalsIgnoreCase(TAB_SHEET_TAB);
    }

    public static void menuBarInsertItemsPropsToAddItem(JavaComponent javaComponent, InsertionPoint insertionPoint, Expression owner, Expression parent, String setterName, Object value, boolean submenu) {
        if (value instanceof LinkedHashMap) {
            LinkedHashMap map = (LinkedHashMap)value;
            if (!map.containsKey("text")) {
                return;
            }
            String menuItemVarName = FlowComponentQuirks.generateVariableName(map, MENU_ITEM, insertionPoint);
            String subMenuVarName = FlowComponentQuirks.generateVariableName(map, SUB_MENU, insertionPoint);
            for (Map.Entry entry : map.entrySet()) {
                String key = entry.getKey().toString();
                Object val = entry.getValue();
                if (key.equalsIgnoreCase("text")) {
                    FlowComponentQuirks.createMenuItem(insertionPoint, owner, setterName, menuItemVarName, val);
                    continue;
                }
                if (!key.equalsIgnoreCase("children") || !(val instanceof List)) continue;
                List children = (List)val;
                FlowComponentQuirks.createSubMenu(insertionPoint, menuItemVarName, subMenuVarName);
                FlowComponentQuirks.addChildren(javaComponent, insertionPoint, subMenuVarName, owner, setterName, children);
            }
        } else {
            throw new IllegalArgumentException("Invalid or not supported items structure for MenuBar with items class " + value.getClass().getName());
        }
    }

    private static String generateVariableName(LinkedHashMap<?, ?> map, String suffix, InsertionPoint insertionPoint) {
        return JavaRewriterUtil.findFreeVariableName(JavaRewriterUtil.getJavaIdentifier(map.get("text").toString(), 10) + suffix, insertionPoint.getBlock());
    }

    private static void createMenuItem(InsertionPoint insertionPoint, Expression owner, String setterName, String menuItemVarName, Object val) {
        ClassOrInterfaceType menuItemType = StaticJavaParser.parseClassOrInterfaceType((String)MENU_ITEM);
        VariableDeclarator variableDeclarator = new VariableDeclarator((Type)menuItemType, menuItemVarName);
        MethodCallExpr addCall = new MethodCallExpr(owner, setterName, new NodeList((Node[])new Expression[]{new StringLiteralExpr(val.toString())}));
        variableDeclarator.setInitializer((Expression)addCall);
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr(variableDeclarator);
        insertionPoint.add((Statement)new ExpressionStmt((Expression)variableDeclarationExpr));
    }

    private static void createSubMenu(InsertionPoint insertionPoint, String menuItemVarName, String subMenuVarName) {
        ClassOrInterfaceType subMenuItemType = StaticJavaParser.parseClassOrInterfaceType((String)SUB_MENU);
        VariableDeclarator subMenuVariableDeclarator = new VariableDeclarator((Type)subMenuItemType, subMenuVarName);
        MethodCallExpr getSubMenu = new MethodCallExpr((Expression)new NameExpr(menuItemVarName), "getSubMenu", new NodeList());
        subMenuVariableDeclarator.setInitializer((Expression)getSubMenu);
        VariableDeclarationExpr subMenuVariableDeclarationExpr = new VariableDeclarationExpr(subMenuVariableDeclarator);
        insertionPoint.add((Statement)new ExpressionStmt((Expression)subMenuVariableDeclarationExpr));
    }

    private static void addChildren(JavaComponent javaComponent, InsertionPoint insertionPoint, String subMenuVarName, Expression owner, String setterName, List<?> children) {
        for (Object child : children) {
            FlowComponentQuirks.menuBarInsertItemsPropsToAddItem(javaComponent, insertionPoint, (Expression)new NameExpr(subMenuVarName), owner, setterName, child, true);
        }
    }

    public static Expression getPropertySetExpression(CompilationUnit compilationUnit, JavaComponent javaComponent, String parentSetterName, String setterName, Object value, Expression owner, InsertionPoint insertionPoint) {
        if (javaComponent.tag() != null && javaComponent.tag().equalsIgnoreCase("Chart")) {
            if (parentSetterName != null && (parentSetterName.equalsIgnoreCase("xAxis") || parentSetterName.equalsIgnoreCase("yAxis"))) {
                if (setterName.equalsIgnoreCase("categories")) {
                    MethodCallExpr getConfigurationCall = new MethodCallExpr(owner, "getConfiguration", new NodeList());
                    MethodCallExpr getAxisCall = new MethodCallExpr((Expression)getConfigurationCall, "get" + parentSetterName, new NodeList());
                    MethodCallExpr setCategoriesCall = new MethodCallExpr((Expression)getAxisCall, "setCategories", new NodeList(JavaRewriterUtil.toExpressionList(value)));
                    return setCategoriesCall;
                }
                if (setterName.equalsIgnoreCase("title")) {
                    Map title = (Map)value;
                    MethodCallExpr getConfigurationCall = new MethodCallExpr(owner, "getConfiguration", new NodeList());
                    MethodCallExpr getAxisCall = new MethodCallExpr((Expression)getConfigurationCall, "get" + parentSetterName, new NodeList());
                    MethodCallExpr setCategoriesCall = new MethodCallExpr((Expression)getAxisCall, "setTitle", new NodeList(JavaRewriterUtil.toExpressionList(title.get("text"))));
                    return setCategoriesCall;
                }
            } else if (!JavaRewriterUtil.hasMethod(HasStyle.class, setterName)) {
                MethodCallExpr getConfigurationCall = new MethodCallExpr(owner, "getConfiguration", new NodeList());
                return getConfigurationCall;
            }
        }
        if (javaComponent.tag() != null && javaComponent.tag().equalsIgnoreCase("ChartSeries") && setterName.equals("setPlotOptions")) {
            MethodCallExpr getSeriesSetPlotOptionsCall = new MethodCallExpr(owner, "setPlotOptions", new NodeList((Node[])new Expression[]{new NameExpr(FlowComponentQuirks.createPlotOptions(value.toString(), insertionPoint, compilationUnit))}));
            return getSeriesSetPlotOptionsCall;
        }
        return owner;
    }

    private static String createPlotOptions(String type, InsertionPoint insertionPoint, CompilationUnit compilationUnit) {
        ExpressionStmt plotOptions = null;
        String className = FlowComponentQuirks.getChartClassName(type);
        String variableName = JavaRewriterUtil.findFreeVariableName(SharedUtil.firstToLower((String)className), insertionPoint.getBlock());
        VariableDeclarator variableDeclarator = new VariableDeclarator((Type)StaticJavaParser.parseClassOrInterfaceType((String)className), variableName);
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(className);
        variableDeclarator.setInitializer((Expression)objectCreationExpr);
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr(variableDeclarator);
        plotOptions = new ExpressionStmt((Expression)variableDeclarationExpr);
        JavaRewriterUtil.addImport(compilationUnit, StaticJavaParser.parseClassOrInterfaceType((String)("com.vaadin.flow.component.charts.model." + className)).getNameWithScope());
        insertionPoint.add((Statement)plotOptions);
        return variableName;
    }

    private static String getChartClassName(String type) {
        if (type.equalsIgnoreCase("bar")) {
            return "PlotOptionsBar";
        }
        if (type.equalsIgnoreCase("line")) {
            return "PlotOptionsLine";
        }
        if (type.equalsIgnoreCase("pie")) {
            return "PlotOptionsPie";
        }
        if (type.equalsIgnoreCase("column")) {
            return "PlotOptionsColumn";
        }
        throw new IllegalArgumentException("Invalid chart type: " + type);
    }
}

