/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.Copilot;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.ErrorsRequest;
import com.vaadin.copilot.analytics.AnalyticsClient;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler
extends CopilotServerClient
implements CopilotCommand {
    private static final Logger logger = LoggerFactory.getLogger(ErrorHandler.class);
    public static final String ERROR_KEY = "error";
    public static final String ERROR_EXCEPTION_MESSAGE_KEY = "errorMessage";
    public static final String ERROR_STACKTRACE_KEY = "errorStacktrace";
    private final boolean sendErrors;

    public static JsonArray toJson(Exception e) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            e.printStackTrace(pw);
        }
        String[] stack = sw.toString().split("\n");
        AtomicBoolean include = new AtomicBoolean(true);
        Stream<String> filtered = Arrays.stream(stack).filter(s -> {
            if (s.contains("com.vaadin.base.devserver.DebugWindowConnection.onMessage")) {
                include.set(false);
            }
            if (!s.startsWith("\t")) {
                include.set(true);
            }
            return include.get();
        });
        return (JsonArray)filtered.map(Json::create).collect(JsonUtils.asArray());
    }

    public static void setError(JsonObject respData, String error) {
        respData.put(ERROR_KEY, error);
    }

    public static void setError(JsonObject respData, String error, Exception e) {
        ErrorHandler.setError(respData, error);
        if (e != null) {
            String exceptionMessage = e.getMessage();
            if (exceptionMessage == null) {
                exceptionMessage = "";
            }
            respData.put(ERROR_EXCEPTION_MESSAGE_KEY, exceptionMessage);
            respData.put(ERROR_STACKTRACE_KEY, (JsonValue)ErrorHandler.toJson(e));
            if (Copilot.isDevelopmentMode()) {
                logger.error("Stack trace because in Copilot development mode", (Throwable)e);
            }
        }
    }

    public static void sendErrorResponse(DevToolsInterface devToolsInterface, String command, JsonObject responseData, String error, Exception e) {
        ErrorHandler.setError(responseData, error, e);
        devToolsInterface.send("copilot-" + command + "-response", responseData);
    }

    public ErrorHandler(boolean sendErrors) {
        this.sendErrors = sendErrors;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (ERROR_KEY.equals(command)) {
            if (!this.sendErrors) {
                return true;
            }
            String proKey = LocalProKey.get().getProKey();
            String machineId = MachineId.get();
            URI uri = this.getQueryURI("errors");
            ErrorsRequest trackingRequest = new ErrorsRequest(machineId, proKey, data.getString("message"), Map.of("details", data.getString("details"), "versions", data.getString("versions")));
            String json = this.writeAsJsonString(trackingRequest);
            HttpRequest request = this.buildRequest(uri, json);
            this.getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString());
            AnalyticsClient.getInstance().track(ERROR_KEY, Map.of("message", data.getString("message")));
            return true;
        }
        return false;
    }
}

