/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.accessibilitychecker;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.plugins.accessibilitychecker.AccessibilityCheckerException;
import com.vaadin.copilot.plugins.themeeditor.Editor;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessibilityJavaSourceModifier
extends Editor {
    private final ProjectManager projectManager;
    private final ErrorHandler errorHandler;
    private final SuccessHandler successHandler;

    public AccessibilityJavaSourceModifier(ProjectManager projectManager, ErrorHandler errorHandler, SuccessHandler successHandler) {
        this.projectManager = projectManager;
        this.errorHandler = errorHandler;
        this.successHandler = successHandler;
    }

    public void setPageTitle(DevToolsInterface devToolsInterface, Integer uiId, String pageTitle) {
        assert (uiId != null && pageTitle != null);
        this.runAsAccess(devToolsInterface, session -> {
            Component currentView = session.getUIById(uiId.intValue()).getCurrentView();
            ArrayList modifications = new ArrayList();
            ComponentTracker.Location createLocation = this.getCreateLocation(currentView);
            File sourceFile = this.projectManager.getFileForClass(currentView.getClass());
            int sourceOffset = this.modifyClass(sourceFile, cu -> {
                Optional classOrInterfaceDeclaration = cu.getClassByName(currentView.getClass().getSimpleName());
                classOrInterfaceDeclaration.ifPresent(node -> {
                    Name name = StaticJavaParser.parseName((String)PageTitle.class.getSimpleName());
                    Optional<AnnotationExpr> pageTitleAnnotationOptional = node.getAnnotations().stream().filter(expr -> name.equals((Object)expr.getName())).findFirst();
                    SingleMemberAnnotationExpr normalAnnotationExpr = new SingleMemberAnnotationExpr(name, (Expression)new StringLiteralExpr(pageTitle));
                    if (pageTitleAnnotationOptional.isPresent()) {
                        AccessibilityJavaSourceModifier.getLogger().debug("update the page title {}", (Object)pageTitle);
                        modifications.add(Editor.Modification.remove((Node)pageTitleAnnotationOptional.get()));
                        node.addAnnotation((AnnotationExpr)normalAnnotationExpr);
                        modifications.add(Editor.Modification.insertLineBefore((Node)node, (Node)normalAnnotationExpr));
                    } else {
                        AccessibilityJavaSourceModifier.getLogger().debug("insert the page title {}", (Object)pageTitle);
                        node.addAnnotation((AnnotationExpr)normalAnnotationExpr);
                        modifications.add(Editor.Modification.addImport((Node)cu, (Node)new ImportDeclaration(PageTitle.class.getName(), false, false)));
                        modifications.add(Editor.Modification.insertLineBefore((Node)node, (Node)normalAnnotationExpr));
                    }
                });
                return modifications;
            });
            if (sourceOffset != 0) {
                ComponentTracker.refreshLocation((ComponentTracker.Location)createLocation, (int)sourceOffset);
            }
        });
    }

    private void runAsAccess(DevToolsInterface devToolsInterface, Consumer<VaadinSession> runnable) {
        VaadinSession session = this.getSession();
        session.access((Command & Serializable)() -> {
            try {
                runnable.accept(session);
                this.successHandler.sendSuccess(devToolsInterface);
            }
            catch (Exception ex) {
                AccessibilityJavaSourceModifier.getLogger().error("Error during the execution", (Throwable)ex);
                this.errorHandler.sendError(devToolsInterface, ex.getMessage());
            }
        });
    }

    protected ComponentTracker.Location getCreateLocation(Component c) {
        ComponentTracker.Location location = ComponentTracker.findCreate((Component)c);
        if (location == null) {
            throw new AccessibilityCheckerException("Unable to find the location where the component " + c.getClass().getName() + " was created");
        }
        return location;
    }

    protected VaadinSession getSession() {
        return VaadinSession.getCurrent();
    }

    protected Component getComponent(VaadinSession session, int uiId, int nodeId) {
        Element element = session.findElement(uiId, nodeId);
        Optional c = element.getComponent();
        if (!c.isPresent()) {
            throw new AccessibilityCheckerException("Only component locations are tracked. The given node id refers to an element and not a component.");
        }
        return (Component)c.get();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AccessibilityJavaSourceModifier.class);
    }

    public static interface ErrorHandler {
        public void sendError(DevToolsInterface var1, String var2);
    }

    public static interface SuccessHandler {
        public void sendSuccess(DevToolsInterface var1);
    }
}

