/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ide;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.ide.CopilotIDEPluginProperties;
import com.vaadin.copilot.ide.IdeUtils;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Optional;

public class IdeHandler
implements CopilotCommand {
    private final CopilotIDEPlugin idePlugin;
    private boolean idePluginActive;
    private final Optional<IdeUtils.IDE> ide;

    public IdeHandler(CopilotIDEPlugin idePlugin) {
        this.idePlugin = idePlugin;
        this.ide = IdeUtils.findIde();
    }

    @Override
    public void handleConnect(DevToolsInterface devToolsInterface) {
        this.idePluginActive = this.idePlugin.isActive();
        this.sendIdePluginState(devToolsInterface);
    }

    private void sendIdePluginState(DevToolsInterface devToolsInterface) {
        JsonObject jsonObject = Json.createObject();
        if (this.idePlugin.isActive()) {
            CopilotIDEPluginProperties props = this.idePlugin.getProperties();
            jsonObject.put("active", true);
            jsonObject.put("version", props.getVersion());
            jsonObject.put("supportedActions", (JsonValue)JsonUtils.listToJson(props.getSupportedActions()));
            jsonObject.put("ide", props.getIde());
        } else {
            jsonObject.put("active", false);
            this.ide.ifPresent(value -> jsonObject.put("ide", value.getPluginIde()));
        }
        devToolsInterface.send("copilot-plugin-state", jsonObject);
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (!this.idePluginActive && this.idePlugin.isActive()) {
            this.idePluginActive = true;
            this.sendIdePluginState(devToolsInterface);
        }
        if (this.idePluginActive && !this.idePlugin.isActive()) {
            this.idePluginActive = false;
            this.sendIdePluginState(devToolsInterface);
        }
        return false;
    }
}

