/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.common;

import com.upyun.library.common.BaseUploader;
import com.upyun.library.exception.RespException;
import com.upyun.library.exception.UpYunException;
import com.upyun.library.utils.UpYunUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SerialUploader
extends BaseUploader {
    public Response resume(String uuid, int nextPartIndex) throws IOException, UpYunException {
        this.uuid = uuid;
        this.nextPartIndex = nextPartIndex;
        if (uuid == null) {
            throw new UpYunException("uuid is null, please restart!");
        }
        this.paused = false;
        return this.startUpload();
    }

    public SerialUploader(String bucketName, String userName, String password) {
        super(bucketName, userName, password);
    }

    public SerialUploader() {
    }

    @Override
    public Response upload(File file, String uploadPath, Map<String, String> params) throws IOException, UpYunException {
        this.init(file, uploadPath, params);
        return this.startUpload();
    }

    @Override
    public Response upload(File file, String uri, String date, String signature, Map<String, String> params) throws IOException, UpYunException {
        this.init(file, uri, date, signature, params);
        return this.startUpload();
    }

    public int getNextPartIndex() {
        return this.nextPartIndex;
    }

    @Override
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setNextPartIndex(int nextPartIndex) {
        this.nextPartIndex = nextPartIndex;
    }

    @Override
    Response processUpload() throws IOException, UpYunException {
        while (this.nextPartIndex >= 0) {
            if (this.paused) {
                throw new UpYunException("upload paused");
            }
            byte[] data = this.readBlockByIndex(this.nextPartIndex);
            RequestBody requestBody = RequestBody.create(null, (byte[])data);
            String md5 = null;
            if (this.checkMD5) {
                md5 = UpYunUtils.md5(data);
            }
            if (!this.signed) {
                this.date = this.getGMTDate();
                this.signature = UpYunUtils.sign("PUT", this.date, this.uri, this.userName, this.password, md5).trim();
            }
            Request.Builder builder = new Request.Builder().url(this.url).header("Date", this.date).header("Authorization", this.signature).header("X-Upyun-Multi-Stage", "upload").header("X-Upyun-Multi-UUID", this.uuid).header("X-Upyun-Part-ID", this.nextPartIndex + "").header("User-Agent", "upyun-android-sdk 2.1.2").put(requestBody);
            if (this.params != null) {
                for (Map.Entry entry : this.params.entrySet()) {
                    builder.header((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (md5 != null) {
                builder.header("Content-MD5", md5);
            }
            if (this.onProgressListener != null) {
                this.onProgressListener.onRequestProgress(this.nextPartIndex + 2, this.totalBlock);
            }
            this.callProcessRequest(builder.build());
        }
        return this.completeUpload();
    }

    @Override
    Response completeUpload() throws IOException, UpYunException {
        Response response = this.completeRequest();
        this.uuid = null;
        if (!response.isSuccessful()) {
            throw new RespException(response.code(), response.body().string());
        }
        this.nextPartIndex = 0;
        return response;
    }

    private void callProcessRequest(Request request) throws IOException, UpYunException {
        Response response = this.mClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
                this.randomAccessFile = null;
            }
            this.uuid = null;
            throw new RespException(response.code(), response.body().string());
        }
        this.uuid = response.header("X-Upyun-Multi-UUID", "");
        this.nextPartIndex = Integer.parseInt(response.header("X-Upyun-Next-Part-ID", "-2"));
    }
}

