/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.common;

import com.upyun.library.common.FormUploader2;
import com.upyun.library.common.UpConfig;
import com.upyun.library.common.UploadClient;
import com.upyun.library.listener.UpCompleteListener;
import com.upyun.library.listener.UpProgressListener;
import com.upyun.library.utils.AsyncRun;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.Response;

public class UploadEngine {
    private static UploadEngine instance;
    private ExecutorService executor = Executors.newFixedThreadPool(UpConfig.CONCURRENCY);
    private UploadClient upLoaderClient = new UploadClient();

    private UploadEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UploadEngine getInstance() {
        if (instance != null) return instance;
        Class<UploadEngine> clazz = UploadEngine.class;
        synchronized (UploadEngine.class) {
            if (instance != null) return instance;
            instance = new UploadEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void formUpload(File file, Map<String, Object> params, String operator, String password, final UpCompleteListener completeListener, final UpProgressListener progressListener) {
        if (params.get("bucket") == null) {
            params.put("bucket", UpConfig.BUCKET);
        }
        if (params.get("expiration") == null) {
            params.put("expiration", System.currentTimeMillis() / 1000L + UpConfig.EXPIRATION);
        }
        UpProgressListener uiProgressListener = new UpProgressListener(){

            @Override
            public void onRequestProgress(final long bytesWrite, final long contentLength) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (progressListener != null) {
                            progressListener.onRequestProgress(bytesWrite, contentLength);
                        }
                    }
                });
            }
        };
        UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final Response response, final Exception error) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        completeListener.onComplete(isSuccess, response, error);
                    }
                });
            }
        };
        HashMap<String, Object> localParams = new HashMap<String, Object>(params);
        FormUploader2 uploadRunnable = new FormUploader2(this.upLoaderClient, file, localParams, operator, password, uiCompleteListener, uiProgressListener);
        this.executor.execute(uploadRunnable);
    }

    public void formUpload(File file, String policy, String operator, String signature, final UpCompleteListener completeListener, final UpProgressListener progressListener) {
        UpProgressListener uiProgressListener = new UpProgressListener(){

            @Override
            public void onRequestProgress(final long bytesWrite, final long contentLength) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (progressListener != null) {
                            progressListener.onRequestProgress(bytesWrite, contentLength);
                        }
                    }
                });
            }
        };
        UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final Response response, final Exception error) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        completeListener.onComplete(isSuccess, response, error);
                    }
                });
            }
        };
        FormUploader2 uploadRunnable = new FormUploader2(this.upLoaderClient, file, policy, operator, signature, uiCompleteListener, uiProgressListener);
        this.executor.execute(uploadRunnable);
    }
}

