/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.common;

import com.upyun.library.common.ProgressHelper;
import com.upyun.library.common.UpConfig;
import com.upyun.library.exception.RespException;
import com.upyun.library.listener.UpProgressListener;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UploadClient {
    private OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)UpConfig.CONNECT_TIMEOUT, TimeUnit.SECONDS).readTimeout((long)UpConfig.READ_TIMEOUT, TimeUnit.SECONDS).writeTimeout((long)UpConfig.WRITE_TIMEOUT, TimeUnit.SECONDS).followRedirects(true).build();

    UploadClient() {
    }

    Response fromUpLoad2(File file, String url, String policy, String operator, String signature, UpProgressListener listener) throws IOException, RespException {
        Request request;
        Response response;
        Object requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("policy", policy).addFormDataPart("authorization", "UPYUN " + operator + ":" + signature).addFormDataPart("file", URLEncoder.encode(file.getName()), RequestBody.create(null, (File)file)).build();
        if (listener != null) {
            requestBody = ProgressHelper.addProgressListener((RequestBody)requestBody, listener);
        }
        if (!(response = this.client.newCall(request = new Request.Builder().addHeader("x-upyun-api-version", "2").header("User-Agent", "upyun-android-sdk 2.1.2").url(url).post((RequestBody)requestBody).build()).execute()).isSuccessful()) {
            throw new RespException(response.code(), response.body().string());
        }
        return response;
    }
}

