/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.common;

import com.upyun.library.common.UpConfig;
import com.upyun.library.common.UploadClient;
import com.upyun.library.exception.RespException;
import com.upyun.library.listener.UpCompleteListener;
import com.upyun.library.listener.UpProgressListener;
import com.upyun.library.utils.Base64Coder;
import com.upyun.library.utils.UpYunUtils;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class FormUploader2
implements Runnable {
    private static final String TAG = "FormUploader2";
    private UploadClient client;
    private File file;
    private String bucket;
    private String policy;
    private String signature;
    private UpProgressListener progressListener;
    private UpCompleteListener completeListener;
    private int retryTime;
    private Map<String, Object> params;
    private String operator;
    private String password;

    public FormUploader2(UploadClient upLoaderClient, File file, Map<String, Object> localParams, String operator, String password, UpCompleteListener uiCompleteListener, UpProgressListener uiProgressListener) {
        this.client = upLoaderClient;
        this.file = file;
        this.bucket = (String)localParams.get("bucket");
        this.params = localParams;
        this.completeListener = uiCompleteListener;
        this.progressListener = uiProgressListener;
        this.operator = operator;
        this.password = password;
    }

    public FormUploader2(UploadClient upLoaderClient, File file, String policy, String operator, String signature, UpCompleteListener uiCompleteListener, UpProgressListener uiProgressListener) {
        this.client = upLoaderClient;
        this.file = file;
        String paramMap = Base64Coder.decodeString(policy);
        try {
            JSONObject obj = new JSONObject(paramMap);
            this.bucket = (String)obj.get("bucket");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.policy = policy;
        this.signature = signature;
        this.completeListener = uiCompleteListener;
        this.progressListener = uiProgressListener;
        this.operator = operator;
    }

    @Override
    public void run() {
        if (this.policy == null || this.operator == null || this.signature == null || this.bucket == null) {
            if (this.params != null && this.operator != null & this.password != null) {
                byte[] hmac;
                this.policy = UpYunUtils.getPolicy(this.params);
                String date = (String)this.params.get("date");
                String contentMd5 = (String)this.params.get("content-md5");
                StringBuilder sb = new StringBuilder();
                String sp = "&";
                sb.append("POST");
                sb.append(sp);
                sb.append("/" + this.bucket);
                if (date != null) {
                    sb.append(sp);
                    sb.append(date);
                }
                sb.append(sp);
                sb.append(this.policy);
                if (contentMd5 != null) {
                    sb.append(sp);
                    sb.append(contentMd5);
                }
                String raw = sb.toString().trim();
                try {
                    hmac = UpYunUtils.calculateRFC2104HMACRaw(this.password, raw);
                }
                catch (SignatureException e) {
                    this.completeListener.onComplete(false, "\u7b7e\u540d\u8ba1\u7b97\u5931\u8d25");
                    return;
                }
                catch (NoSuchAlgorithmException e) {
                    this.completeListener.onComplete(false, "\u627e\u4e0d\u5230 SHA1 \u7b97\u6cd5");
                    return;
                }
                catch (InvalidKeyException e) {
                    this.completeListener.onComplete(false, "password \u9519\u8bef");
                    return;
                }
                if (hmac != null) {
                    this.signature = Base64Coder.encodeLines(hmac);
                }
            } else {
                this.completeListener.onComplete(false, "\u53c2\u6570\u9519\u8bef");
                return;
            }
        }
        String url = "https://v0.api.upyun.com/" + this.bucket;
        try {
            String response = this.client.fromUpLoad2(this.file, url, this.policy, this.operator, this.signature, this.progressListener);
            this.completeListener.onComplete(true, response);
        }
        catch (RespException | IOException e) {
            if (++this.retryTime > UpConfig.RETRY_TIME || e instanceof RespException && ((RespException)e).code() / 100 != 5) {
                this.completeListener.onComplete(false, e.toString());
            }
            this.run();
        }
    }
}

