/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.common;

import android.util.Log;
import com.upyun.library.common.PostData;
import com.upyun.library.common.UpConfig;
import com.upyun.library.common.UploadClient;
import com.upyun.library.exception.RespException;
import com.upyun.library.exception.UpYunException;
import com.upyun.library.listener.SignatureListener;
import com.upyun.library.listener.UpCompleteListener;
import com.upyun.library.listener.UpProgressListener;
import com.upyun.library.utils.UpYunUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BlockUploader
implements Runnable {
    private static final String TAG = "BlockUploader";
    private String bucket;
    private String url;
    private long expiration;
    private UpProgressListener progressListener;
    private UpCompleteListener completeListener;
    private File file;
    private UploadClient client;
    private String userPolicy;
    private String userSignature;
    private int totalBlockNum;
    private String saveToken;
    private String tokenSecret;
    private RandomAccessFile randomAccessFile = null;
    private int[] blockIndex;
    private PostData postData;
    private Map<String, Object> params;
    private String apiKey;
    private SignatureListener signatureListener;
    private int retryTime;

    public BlockUploader(UploadClient upLoaderClient, File file, Map<String, Object> localParams, String apiKey, SignatureListener signatureListener, UpCompleteListener uiCompleteListener, UpProgressListener uiProgressListener) {
        this.client = upLoaderClient;
        this.file = file;
        this.params = localParams;
        this.progressListener = uiProgressListener;
        this.completeListener = uiCompleteListener;
        this.apiKey = apiKey;
        this.signatureListener = signatureListener;
    }

    @Override
    public void run() {
        try {
            this.bucket = (String)this.params.remove("bucket");
            this.url = "http://m0.api.upyun.com/" + this.bucket;
            this.expiration = (Long)this.params.get("expiration");
            this.params.put("file_blocks", UpYunUtils.getBlockNum(this.file, UpConfig.BLOCK_SIZE));
            this.params.put("file_size", this.file.length());
            this.params.put("file_hash", UpYunUtils.md5Hex(this.file));
            String save_path = (String)this.params.remove("save-key");
            String path = (String)this.params.get("path");
            if (save_path != null && path == null) {
                this.params.put("path", save_path);
            }
            this.userPolicy = UpYunUtils.getPolicy(this.params);
            if (this.apiKey != null) {
                this.userSignature = UpYunUtils.getSignature(this.userPolicy, this.apiKey);
            } else if (this.signatureListener != null) {
                this.userSignature = this.signatureListener.getSignature(this.getParamsString(this.params));
            } else {
                throw new RuntimeException("apiKey \u548c signatureListener \u4e0d\u53ef\u90fd\u4e3a null");
            }
            this.randomAccessFile = new RandomAccessFile(this.file, "r");
            this.totalBlockNum = UpYunUtils.getBlockNum(this.file, UpConfig.BLOCK_SIZE);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
        this.initRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockUpload(int index) {
        while (true) {
            if (this.postData == null) {
                this.postData = new PostData();
            }
            try {
                this.postData.data = this.readBlockByIndex(index);
            }
            catch (UpYunException e) {
                this.completeListener.onComplete(false, e.toString());
            }
            HashMap<String, Object> policyMap = new HashMap<String, Object>();
            policyMap.put("save_token", this.saveToken);
            policyMap.put("expiration", this.expiration);
            policyMap.put("block_index", this.blockIndex[index]);
            policyMap.put("block_hash", UpYunUtils.md5(this.postData.data));
            String policy = UpYunUtils.getPolicy(policyMap);
            String signature = UpYunUtils.getSignature(policyMap, this.tokenSecret);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("policy", policy);
            map.put("signature", signature);
            this.postData.fileName = this.file.getName();
            this.postData.params = map;
            try {
                this.client.blockMultipartPost(this.url, this.postData);
                if (this.progressListener != null) {
                    this.progressListener.onRequestProgress(index, this.blockIndex.length);
                }
                if (index++ != this.blockIndex.length - 1) continue;
                this.mergeRequest();
            }
            catch (RespException | IOException e) {
                if (++this.retryTime <= UpConfig.RETRY_TIME && (!(e instanceof RespException) || ((RespException)e).code() / 100 == 5)) continue;
                this.completeListener.onComplete(false, e.toString());
            }
            finally {
                this.postData = null;
                continue;
            }
            break;
        }
    }

    private void mergeRequest() {
        HashMap<String, Object> paramsMapFinish = new HashMap<String, Object>();
        paramsMapFinish.put("expiration", this.expiration);
        paramsMapFinish.put("save_token", this.saveToken);
        String policyForMerge = UpYunUtils.getPolicy(paramsMapFinish);
        String signatureForMerge = UpYunUtils.getSignature(paramsMapFinish, this.tokenSecret);
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("policy", policyForMerge);
        paramMap.put("signature", signatureForMerge);
        try {
            String response = this.client.post(this.url, paramMap);
            this.progressListener.onRequestProgress(this.blockIndex.length, this.blockIndex.length);
            this.completeListener.onComplete(true, response);
        }
        catch (RespException | IOException e) {
            if (++this.retryTime > UpConfig.RETRY_TIME || e instanceof RespException && ((RespException)e).code() / 100 != 5) {
                this.completeListener.onComplete(false, e.toString());
            }
            this.mergeRequest();
        }
    }

    private void initRequest() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("policy", this.userPolicy);
        paramMap.put("signature", this.userSignature);
        try {
            String response = this.client.post(this.url, paramMap);
            JSONObject initialResult = new JSONObject(response);
            this.saveToken = initialResult.optString("save_token");
            this.tokenSecret = initialResult.optString("token_secret");
            JSONArray array = initialResult.getJSONArray("status");
            this.blockIndex = this.getBlockIndex(array);
            if (this.blockIndex.length == 0) {
                this.mergeRequest();
            } else {
                this.blockUpload(0);
            }
        }
        catch (RespException | IOException e) {
            if (++this.retryTime > UpConfig.RETRY_TIME || e instanceof RespException && ((RespException)e).code() / 100 != 5) {
                this.completeListener.onComplete(false, e.toString());
            } else {
                this.initRequest();
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("json \u89e3\u6790\u51fa\u9519", e);
        }
    }

    private byte[] readBlockByIndex(int index) throws UpYunException {
        if (index > this.totalBlockNum) {
            Log.e((String)"Block index error", (String)"the index is bigger than totalBlockNum.");
            throw new UpYunException("readBlockByIndex: the index is bigger than totalBlockNum.");
        }
        byte[] block = new byte[UpConfig.BLOCK_SIZE];
        int readedSize = 0;
        try {
            int offset = this.blockIndex[index] * UpConfig.BLOCK_SIZE;
            this.randomAccessFile.seek(offset);
            readedSize = this.randomAccessFile.read(block, 0, UpConfig.BLOCK_SIZE);
        }
        catch (IOException e) {
            throw new UpYunException(e.getMessage());
        }
        if (readedSize < UpConfig.BLOCK_SIZE) {
            byte[] notFullBlock = new byte[readedSize];
            System.arraycopy(block, 0, notFullBlock, 0, readedSize);
            return notFullBlock;
        }
        return block;
    }

    private int[] getBlockIndex(JSONArray array) throws JSONException {
        int size = 0;
        for (int i = 0; i < array.length(); ++i) {
            if (array.getInt(i) != 0) continue;
            ++size;
        }
        int[] blockIndex = new int[size];
        int index = 0;
        for (int i = 0; i < array.length(); ++i) {
            if (array.getInt(i) != 0) continue;
            blockIndex[index] = i;
            ++index;
        }
        return blockIndex;
    }

    private String getParamsString(Map<String, Object> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder("");
        for (String key : keys) {
            builder.append(key).append(params.get(key));
        }
        return builder.toString();
    }
}

