/*
 * Decompiled with CFR 0.152.
 */
package com.updateimpact;

import com.google.gson.Gson;
import com.updateimpact.SubmitLogger;
import com.updateimpact.SubmitResponse;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class ReportSubmitter {
    private static final HttpClient HTTP_CLIENT = HttpClientBuilder.create().build();
    private final String url;
    private final SubmitLogger log;

    public ReportSubmitter(String url, SubmitLogger log) {
        this.url = url;
        this.log = log;
    }

    public String trySubmitReport(String report) throws RuntimeException {
        try {
            return this.submitReport(report);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception when submitting the dependency report", e);
        }
    }

    public String submitReport(String report) throws IOException {
        String submitUrl = this.url + "/api/submit";
        this.log.info("");
        this.log.info("Submitting dependency report to " + submitUrl);
        HttpPost post = new HttpPost(submitUrl);
        post.setEntity((HttpEntity)new StringEntity(report));
        HttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)post);
        String responseJson = EntityUtils.toString((HttpEntity)response.getEntity());
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode < 200 || statusCode > 300) {
            this.log.error("Cannot submit report to " + submitUrl + ", got response " + statusCode + ": " + responseJson);
            return null;
        }
        SubmitResponse submitResponse = (SubmitResponse)new Gson().fromJson(responseJson, SubmitResponse.class);
        String viewLink = this.url + "/#/builds/" + submitResponse.getUserIdStr() + "/" + submitResponse.getBuildId();
        this.log.info("");
        this.log.info("Dependency report submitted. You can view it at: ");
        this.log.info(viewLink);
        this.log.info("");
        return viewLink;
    }
}

