/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class URLArgumentValueValidator
extends ArgumentValueValidator
implements Serializable {
    private static final long serialVersionUID = -4431100566624433212L;
    private final Set<String> allowedSchemes;

    public URLArgumentValueValidator(String ... allowedSchemes) {
        this(StaticUtils.toList(allowedSchemes));
    }

    public URLArgumentValueValidator(Collection<String> allowedSchemes) {
        this.allowedSchemes = allowedSchemes == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(allowedSchemes));
    }

    public Set<String> getAllowedSchemes() {
        return this.allowedSchemes;
    }

    @Override
    public void validateArgumentValue(Argument argument, String valueString) throws ArgumentException {
        URI uri;
        try {
            uri = new URI(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ArgumentException(ArgsMessages.ERR_URL_VALIDATOR_VALUE_NOT_URL.get(valueString, argument.getIdentifierString(), StaticUtils.getExceptionMessage(e)), e);
        }
        if (uri.getScheme() == null) {
            throw new ArgumentException(ArgsMessages.ERR_URL_VALIDATOR_MISSING_SCHEME.get(valueString, argument.getIdentifierString()));
        }
        if (!this.allowedSchemes.isEmpty() && !this.allowedSchemes.contains(uri.getScheme())) {
            throw new ArgumentException(ArgsMessages.ERR_URL_VALIDATOR_UNACCEPTABLE_SCHEME.get(valueString, argument.getIdentifierString(), uri.getScheme()));
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("URLArgumentValueValidator(");
        if (this.allowedSchemes != null) {
            buffer.append("allowedSchemes={");
            Iterator<String> iterator = this.allowedSchemes.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

