/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.util.LDAPSDKException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDIFException
extends LDAPSDKException {
    private static final long serialVersionUID = 1665883395956836732L;
    private final boolean mayContinueReading;
    private final long lineNumber;
    private final List<String> dataLines;

    public LDIFException(String message, long lineNumber, boolean mayContinueReading) {
        this(message, lineNumber, mayContinueReading, (List<? extends CharSequence>)null, null);
    }

    public LDIFException(String message, long lineNumber, boolean mayContinueReading, Throwable cause) {
        this(message, lineNumber, mayContinueReading, (List<? extends CharSequence>)null, cause);
    }

    public LDIFException(String message, long lineNumber, boolean mayContinueReading, CharSequence[] dataLines, Throwable cause) {
        this(message, lineNumber, mayContinueReading, dataLines == null ? null : Arrays.asList(dataLines), cause);
    }

    public LDIFException(String message, long lineNumber, boolean mayContinueReading, List<? extends CharSequence> dataLines, Throwable cause) {
        super(message, cause);
        Validator.ensureNotNull(message);
        this.lineNumber = lineNumber;
        this.mayContinueReading = mayContinueReading;
        if (dataLines == null) {
            this.dataLines = null;
        } else {
            ArrayList<String> lineList = new ArrayList<String>(dataLines.size());
            for (CharSequence charSequence : dataLines) {
                lineList.add(charSequence.toString());
            }
            this.dataLines = Collections.unmodifiableList(lineList);
        }
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public boolean mayContinueReading() {
        return this.mayContinueReading;
    }

    public List<String> getDataLines() {
        return this.dataLines;
    }

    @Override
    public void toString(StringBuilder buffer) {
        boolean includeCause = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeCauseInExceptionMessages");
        boolean includeStackTrace = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeStackTraceInExceptionMessages");
        this.toString(buffer, includeCause, includeStackTrace);
    }

    public void toString(StringBuilder buffer, boolean includeCause, boolean includeStackTrace) {
        Throwable cause;
        buffer.append("LDIFException(lineNumber=");
        buffer.append(this.lineNumber);
        buffer.append(", mayContinueReading=");
        buffer.append(this.mayContinueReading);
        buffer.append(", message='");
        buffer.append(this.getMessage());
        if (this.dataLines != null) {
            buffer.append("', dataLines='");
            for (CharSequence charSequence : this.dataLines) {
                buffer.append(charSequence);
                buffer.append("{end-of-line}");
            }
        }
        if (includeStackTrace) {
            buffer.append(", trace='");
            StaticUtils.getStackTrace(this.getStackTrace(), buffer);
            buffer.append('\'');
        }
        if ((includeCause || includeStackTrace) && (cause = this.getCause()) != null) {
            buffer.append(", cause=");
            buffer.append(StaticUtils.getExceptionMessage(cause, true, includeStackTrace));
        }
        String ldapSDKVersionString = ", ldapSDKVersion=4.0.11, revision=34e39aab27ea4fb92659a6888933db08099c7e41";
        if (buffer.indexOf(", ldapSDKVersion=4.0.11, revision=34e39aab27ea4fb92659a6888933db08099c7e41") < 0) {
            buffer.append(", ldapSDKVersion=4.0.11, revision=34e39aab27ea4fb92659a6888933db08099c7e41");
        }
        buffer.append(')');
    }

    @Override
    public String getExceptionMessage() {
        return this.toString();
    }

    @Override
    public String getExceptionMessage(boolean includeCause, boolean includeStackTrace) {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, includeCause, includeStackTrace);
        return buffer.toString();
    }
}

