/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.EntrySource;
import com.unboundid.ldap.sdk.EntrySourceException;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchResultReferenceEntrySourceException;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPEntrySource
extends EntrySource
implements AsyncSearchResultListener {
    private static final String END_OF_RESULTS = "END OF RESULTS";
    private static final long serialVersionUID = 1080386705549149135L;
    private final AsyncRequestID asyncRequestID;
    private final AtomicBoolean closed;
    private final AtomicReference<SearchResult> searchResult;
    private final boolean closeConnection;
    private final LDAPConnection connection;
    private final LinkedBlockingQueue<Object> queue;

    public LDAPEntrySource(LDAPConnection connection, SearchRequest searchRequest, boolean closeConnection) throws LDAPException {
        this(connection, searchRequest, closeConnection, 100);
    }

    public LDAPEntrySource(LDAPConnection connection, SearchRequest searchRequest, boolean closeConnection, int queueSize) throws LDAPException {
        Validator.ensureNotNull(connection, searchRequest);
        Validator.ensureTrue(queueSize > 0, "LDAPEntrySource.queueSize must be greater than 0.");
        this.connection = connection;
        this.closeConnection = closeConnection;
        if (searchRequest.getSearchResultListener() != null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_LDAP_ENTRY_SOURCE_REQUEST_HAS_LISTENER.get());
        }
        this.closed = new AtomicBoolean(false);
        this.searchResult = new AtomicReference();
        this.queue = new LinkedBlockingQueue(queueSize);
        SearchRequest r = new SearchRequest((SearchResultListener)this, searchRequest.getControls(), searchRequest.getBaseDN(), searchRequest.getScope(), searchRequest.getDereferencePolicy(), searchRequest.getSizeLimit(), searchRequest.getTimeLimitSeconds(), searchRequest.typesOnly(), searchRequest.getFilter(), searchRequest.getAttributes());
        this.asyncRequestID = connection.asyncSearch(r);
    }

    public Entry nextEntry() throws EntrySourceException {
        Object o;
        do {
            if (this.closed.get() && this.queue.isEmpty()) {
                return null;
            }
            try {
                o = this.queue.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new EntrySourceException(true, LDAPMessages.ERR_LDAP_ENTRY_SOURCE_NEXT_ENTRY_INTERRUPTED.get(), ie);
            }
        } while (o == null);
        if (o == END_OF_RESULTS) {
            return null;
        }
        if (o instanceof Entry) {
            return (Entry)o;
        }
        throw (EntrySourceException)o;
    }

    public void close() {
        this.closeInternal(true);
    }

    private void closeInternal(boolean abandon) {
        this.addToQueue(END_OF_RESULTS);
        if (this.closed.compareAndSet(false, true)) {
            if (abandon) {
                try {
                    this.connection.abandon(this.asyncRequestID);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            if (this.closeConnection) {
                this.connection.close();
            }
        }
    }

    public SearchResult getSearchResult() {
        return this.searchResult.get();
    }

    @InternalUseOnly
    public void searchEntryReturned(SearchResultEntry searchEntry) {
        this.addToQueue(searchEntry);
    }

    @InternalUseOnly
    public void searchReferenceReturned(SearchResultReference searchReference) {
        this.addToQueue(new SearchResultReferenceEntrySourceException(searchReference));
    }

    @InternalUseOnly
    public void searchResultReceived(AsyncRequestID requestID, SearchResult searchResult) {
        this.searchResult.set(searchResult);
        if (!searchResult.getResultCode().equals(ResultCode.SUCCESS)) {
            this.addToQueue(new EntrySourceException(false, (Throwable)new LDAPSearchException(searchResult)));
        }
        this.closeInternal(false);
    }

    private void addToQueue(Object o) {
        while (!this.closed.get()) {
            try {
                if (!this.queue.offer(o, 100L, TimeUnit.MILLISECONDS)) continue;
                return;
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                continue;
            }
            break;
        }
        return;
    }
}

