/*
 * Decompiled with CFR 0.152.
 */
package com.ufoscout.coreutils.auth;

import com.ufoscout.coreutils.auth.Role;
import com.ufoscout.coreutils.auth.RoleStore;
import com.ufoscout.coreutils.auth.RolesEncoder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RolesEncoderToLong
implements RolesEncoder<Long> {
    private static final Logger log = LoggerFactory.getLogger(RolesEncoderToLong.class);

    @Override
    public Long encode(RoleStore store, String ... roleNames) {
        long result = 0L;
        for (String roleName : roleNames) {
            Role role = store.byName.get(roleName);
            if (role == null) {
                log.warn("Role [{}] does not exists", (Object)roleName);
                continue;
            }
            result |= 1L << role.getId();
        }
        return result;
    }

    @Override
    public List<Role> decode(RoleStore store, Long roles) {
        long longRole = roles;
        ArrayList<Role> result = new ArrayList<Role>();
        for (int i = 0; i < store.byId.length; ++i) {
            if ((longRole & 1L << i) == 0L) continue;
            result.add(store.byId[i]);
        }
        return result;
    }
}

