/*
 * Decompiled with CFR 0.152.
 */
package com.ufoscout.coreutils.auth;

import com.ufoscout.coreutils.auth.AuthDecoder;
import com.ufoscout.coreutils.auth.Role;
import com.ufoscout.coreutils.auth.UnauthenticatedException;
import com.ufoscout.coreutils.auth.UnauthorizedException;
import com.ufoscout.coreutils.auth.User;
import java.util.ArrayList;
import java.util.List;

public final class AuthContext<R> {
    private final User<R> user;
    private final List<String> userRoles = new ArrayList<String>();
    private final List<String> userPermissions = new ArrayList<String>();

    public AuthContext(User<R> user, AuthDecoder<R> authDecoder) {
        this.user = user;
        for (Role role : authDecoder.decode(user.getRoles())) {
            this.userRoles.add(role.getName());
            for (String permission : role.getPermissions()) {
                this.userPermissions.add(permission);
            }
        }
    }

    public final AuthContext isAuthenticated() {
        String username = this.user.getUsername();
        if (username.length() == 0) {
            throw new UnauthenticatedException("User needs to be authenticated.");
        }
        return this;
    }

    public final AuthContext hasRole(String role) {
        this.isAuthenticated();
        if (this.booleanHasRole(role)) {
            return this;
        }
        throw new UnauthorizedException("User [" + this.user.getUsername() + "] does not have the required roles.");
    }

    public final AuthContext hasAnyRole(String ... roles) {
        this.isAuthenticated();
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i];
            if (!this.booleanHasRole(role)) continue;
            return this;
        }
        throw new UnauthorizedException("User [" + this.user.getUsername() + "] does not have the required roles.");
    }

    public final AuthContext hasAllRoles(String ... roles) {
        this.isAuthenticated();
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i];
            if (this.booleanHasRole(role)) continue;
            throw new UnauthorizedException("User [" + this.user.getUsername() + "] does not have the required roles.");
        }
        return this;
    }

    public final AuthContext hasPermission(String permission) {
        this.isAuthenticated();
        if (this.booleanHasPermission(permission)) {
            return this;
        }
        throw new UnauthorizedException("User [" + this.user.getUsername() + "] does not have the required permissions.");
    }

    public final AuthContext hasAnyPermission(String ... permissions) {
        this.isAuthenticated();
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            if (!this.booleanHasPermission(permission)) continue;
            return this;
        }
        throw new UnauthorizedException("User [" + this.user.getUsername() + "] does not have the required permissions.");
    }

    public final AuthContext hasAllPermissions(String ... permissions) {
        this.isAuthenticated();
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            if (this.booleanHasPermission(permission)) continue;
            throw new UnauthorizedException("User [" + this.user.getUsername() + "] does not have the required permissions.");
        }
        return this;
    }

    private final boolean booleanHasRole(String role) {
        return this.userRoles.contains(role);
    }

    private final boolean booleanHasPermission(String permission) {
        return this.userPermissions.contains(permission);
    }

    public final User getUser() {
        return this.user;
    }
}

