/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetcomposer;

import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import com.twitter.Validator;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterApiClient;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.TwitterSession;
import com.twitter.sdk.android.core.models.User;
import com.twitter.sdk.android.tweetcomposer.ComposerActivity;
import com.twitter.sdk.android.tweetcomposer.ComposerScribeClient;
import com.twitter.sdk.android.tweetcomposer.ComposerScribeClientImpl;
import com.twitter.sdk.android.tweetcomposer.ComposerView;
import com.twitter.sdk.android.tweetcomposer.R;
import com.twitter.sdk.android.tweetcomposer.TweetComposer;
import com.twitter.sdk.android.tweetcomposer.TweetUploadService;
import retrofit2.Callback;

class ComposerController {
    final ComposerView composerView;
    final TwitterSession session;
    final Uri imageUri;
    final ComposerActivity.Finisher finisher;
    final DependencyProvider dependencyProvider;

    ComposerController(ComposerView composerView, TwitterSession session, Uri imageUri, String text, String hashtags, ComposerActivity.Finisher finisher) {
        this(composerView, session, imageUri, text, hashtags, finisher, new DependencyProvider());
    }

    ComposerController(ComposerView composerView, TwitterSession session, Uri imageUri, String text, String hashtags, ComposerActivity.Finisher finisher, DependencyProvider dependencyProvider) {
        this.composerView = composerView;
        this.session = session;
        this.imageUri = imageUri;
        this.finisher = finisher;
        this.dependencyProvider = dependencyProvider;
        composerView.setCallbacks(new ComposerCallbacksImpl());
        composerView.setTweetText(this.generateText(text, hashtags));
        this.setProfilePhoto();
        this.setImageView(imageUri);
        dependencyProvider.getScribeClient().impression();
    }

    String generateText(String text, String hashtags) {
        StringBuilder sb = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            sb.append(text);
        }
        if (!TextUtils.isEmpty((CharSequence)hashtags)) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(hashtags);
        }
        return sb.toString();
    }

    void setProfilePhoto() {
        this.dependencyProvider.getApiClient(this.session).getAccountService().verifyCredentials(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)).enqueue((Callback)new com.twitter.sdk.android.core.Callback<User>(){

            public void success(Result<User> result) {
                ComposerController.this.composerView.setProfilePhotoView((User)result.data);
            }

            public void failure(TwitterException exception) {
                ComposerController.this.composerView.setProfilePhotoView(null);
            }
        });
    }

    void setImageView(Uri imageUri) {
        if (imageUri != null) {
            this.composerView.setImageView(imageUri);
        }
    }

    void onClose() {
        this.dependencyProvider.getScribeClient().click("cancel");
        this.sendCancelBroadcast();
        this.finisher.finish();
    }

    int tweetTextLength(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return 0;
        }
        return this.dependencyProvider.getTweetValidator().getTweetLength(text);
    }

    void sendCancelBroadcast() {
        Intent intent = new Intent("com.twitter.sdk.android.tweetcomposer.TWEET_COMPOSE_CANCEL");
        intent.setPackage(this.composerView.getContext().getPackageName());
        this.composerView.getContext().sendBroadcast(intent);
    }

    static int remainingCharCount(int charCount) {
        return 140 - charCount;
    }

    static boolean isPostEnabled(int charCount) {
        return charCount > 0 && charCount <= 140;
    }

    static boolean isTweetTextOverflow(int charCount) {
        return charCount > 140;
    }

    static class DependencyProvider {
        final Validator tweetValidator = new Validator();

        DependencyProvider() {
        }

        TwitterApiClient getApiClient(TwitterSession session) {
            return TwitterCore.getInstance().getApiClient(session);
        }

        Validator getTweetValidator() {
            return this.tweetValidator;
        }

        ComposerScribeClient getScribeClient() {
            return new ComposerScribeClientImpl(TweetComposer.getInstance().getScribeClient());
        }
    }

    class ComposerCallbacksImpl
    implements ComposerCallbacks {
        ComposerCallbacksImpl() {
        }

        @Override
        public void onTextChanged(String text) {
            int charCount = ComposerController.this.tweetTextLength(text);
            ComposerController.this.composerView.setCharCount(ComposerController.remainingCharCount(charCount));
            if (ComposerController.isTweetTextOverflow(charCount)) {
                ComposerController.this.composerView.setCharCountTextStyle(R.style.tw__ComposerCharCountOverflow);
            } else {
                ComposerController.this.composerView.setCharCountTextStyle(R.style.tw__ComposerCharCount);
            }
            ComposerController.this.composerView.postTweetEnabled(ComposerController.isPostEnabled(charCount));
        }

        @Override
        public void onTweetPost(String text) {
            ComposerController.this.dependencyProvider.getScribeClient().click("tweet");
            Intent intent = new Intent(ComposerController.this.composerView.getContext(), TweetUploadService.class);
            intent.putExtra("EXTRA_USER_TOKEN", (Parcelable)ComposerController.this.session.getAuthToken());
            intent.putExtra("EXTRA_TWEET_TEXT", text);
            intent.putExtra("EXTRA_IMAGE_URI", (Parcelable)ComposerController.this.imageUri);
            ComposerController.this.composerView.getContext().startService(intent);
            ComposerController.this.finisher.finish();
        }

        @Override
        public void onCloseClick() {
            ComposerController.this.onClose();
        }
    }

    static interface ComposerCallbacks {
        public void onTextChanged(String var1);

        public void onTweetPost(String var1);

        public void onCloseClick();
    }
}

