/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.metadata;

import java.util.Set;
import parquet.column.Encoding;
import parquet.column.statistics.Statistics;
import parquet.common.schema.ColumnPath;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ColumnChunkProperties;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.schema.PrimitiveType;

class IntColumnChunkMetaData
extends ColumnChunkMetaData {
    private final int firstDataPage;
    private final int dictionaryPageOffset;
    private final int valueCount;
    private final int totalSize;
    private final int totalUncompressedSize;
    private final Statistics statistics;

    IntColumnChunkMetaData(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, Set<Encoding> encodings, Statistics statistics, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        super(ColumnChunkProperties.get(path, type, codec, encodings));
        this.firstDataPage = this.positiveLongToInt(firstDataPage);
        this.dictionaryPageOffset = this.positiveLongToInt(dictionaryPageOffset);
        this.valueCount = this.positiveLongToInt(valueCount);
        this.totalSize = this.positiveLongToInt(totalSize);
        this.totalUncompressedSize = this.positiveLongToInt(totalUncompressedSize);
        this.statistics = statistics;
    }

    private int positiveLongToInt(long value) {
        if (!ColumnChunkMetaData.positiveLongFitsInAnInt(value)) {
            throw new IllegalArgumentException("value should be positive and fit in an int: " + value);
        }
        return (int)(value + Integer.MIN_VALUE);
    }

    private long intToPositiveLong(int value) {
        return (long)value - Integer.MIN_VALUE;
    }

    @Override
    public long getFirstDataPageOffset() {
        return this.intToPositiveLong(this.firstDataPage);
    }

    @Override
    public long getDictionaryPageOffset() {
        return this.intToPositiveLong(this.dictionaryPageOffset);
    }

    @Override
    public long getValueCount() {
        return this.intToPositiveLong(this.valueCount);
    }

    @Override
    public long getTotalUncompressedSize() {
        return this.intToPositiveLong(this.totalUncompressedSize);
    }

    @Override
    public long getTotalSize() {
        return this.intToPositiveLong(this.totalSize);
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }
}

