/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.color.ColorSpaces;
import com.twelvemonkeys.imageio.plugins.psd.ICCProfile;
import com.twelvemonkeys.imageio.plugins.psd.PSDChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDColorData;
import com.twelvemonkeys.imageio.plugins.psd.PSDDirectoryResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDGlobalLayerMask;
import com.twelvemonkeys.imageio.plugins.psd.PSDHeader;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDMetadata;
import com.twelvemonkeys.imageio.plugins.psd.PSDThumbnail;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class PSDImageReader
extends ImageReaderBase {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.plugins.psd.debug"));
    private PSDHeader header;
    private ICC_ColorSpace colorSpace;
    private PSDMetadata metadata;

    PSDImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
        this.header = null;
        this.metadata = null;
        this.colorSpace = null;
    }

    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        if (n > 0) {
            return this.getLayerWidth(n - 1);
        }
        return this.header.width;
    }

    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        if (n > 0) {
            return this.getLayerHeight(n - 1);
        }
        return this.header.height;
    }

    private int getLayerWidth(int n) throws IOException {
        this.readLayerAndMaskInfo(true);
        PSDLayerInfo pSDLayerInfo = this.metadata.layerInfo.get(n);
        return pSDLayerInfo.right - pSDLayerInfo.left;
    }

    private int getLayerHeight(int n) throws IOException {
        this.readLayerAndMaskInfo(true);
        PSDLayerInfo pSDLayerInfo = this.metadata.layerInfo.get(n);
        return pSDLayerInfo.bottom - pSDLayerInfo.top;
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        return this.getRawImageTypeInternal(n);
    }

    private ImageTypeSpecifier getRawImageTypeInternal(int n) throws IOException {
        this.checkBounds(n);
        if (n > 0) {
            this.readLayerAndMaskInfo(true);
            return this.getRawImageTypeForLayer(n - 1);
        }
        return this.getRawImageTypeForCompositeLayer();
    }

    private ImageTypeSpecifier getRawImageTypeForCompositeLayer() throws IOException {
        switch (this.header.mode) {
            case 0: {
                if (this.header.channels == 1 && this.header.bits == 1) {
                    return ImageTypeSpecifiers.createFromBufferedImageType((int)12);
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for Monochrome PSD: %d channels/%d bits", this.header.channels, this.header.bits));
            }
            case 2: {
                if (this.header.channels == 1 && this.header.bits == 8) {
                    return ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)this.metadata.colorData.getIndexColorModel());
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for Indexed Color PSD: %d channels/%d bits", this.header.channels, this.header.bits));
            }
            case 1: 
            case 8: {
                ColorSpace colorSpace = this.getEmbeddedColorSpace();
                if (colorSpace == null) {
                    colorSpace = ColorSpace.getInstance(1003);
                }
                if (this.header.channels >= 1) {
                    switch (this.header.bits) {
                        case 8: {
                            return this.metadata.hasAlpha() && this.header.channels > 1 ? ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1}, (int[])new int[]{0, 0}, (int)0, (boolean)true, (boolean)false) : ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0}, (int[])new int[]{0}, (int)0, (boolean)false, (boolean)false);
                        }
                        case 16: {
                            return this.metadata.hasAlpha() && this.header.channels > 1 ? ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1}, (int[])new int[]{0, 0}, (int)1, (boolean)true, (boolean)false) : ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0}, (int[])new int[]{0}, (int)1, (boolean)false, (boolean)false);
                        }
                        case 32: {
                            return this.metadata.hasAlpha() && this.header.channels > 1 ? ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1}, (int[])new int[]{0, 0}, (int)3, (boolean)true, (boolean)false) : ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0}, (int[])new int[]{0}, (int)3, (boolean)false, (boolean)false);
                        }
                    }
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for Gray Scale PSD: %d channels/%d bits", this.header.channels, this.header.bits));
            }
            case 3: {
                ColorSpace colorSpace = this.getEmbeddedColorSpace();
                if (colorSpace == null) {
                    colorSpace = ColorSpace.getInstance(1000);
                }
                if (this.header.channels >= 3) {
                    switch (this.header.bits) {
                        case 8: {
                            return this.metadata.hasAlpha() && this.header.channels > 3 ? ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)0, (boolean)true, (boolean)false) : ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2}, (int[])new int[]{0, 0, 0}, (int)0, (boolean)false, (boolean)false);
                        }
                        case 16: {
                            return this.metadata.hasAlpha() && this.header.channels > 3 ? ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)1, (boolean)true, (boolean)false) : ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2}, (int[])new int[]{0, 0, 0}, (int)1, (boolean)false, (boolean)false);
                        }
                        case 32: {
                            return this.metadata.hasAlpha() && this.header.channels > 3 ? ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)3, (boolean)true, (boolean)false) : ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2}, (int[])new int[]{0, 0, 0}, (int)3, (boolean)false, (boolean)false);
                        }
                    }
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for RGB PSD: %d channels/%d bits", this.header.channels, this.header.bits));
            }
            case 4: {
                ColorSpace colorSpace = this.getEmbeddedColorSpace();
                if (colorSpace == null) {
                    colorSpace = ColorSpaces.getColorSpace((int)5001);
                }
                if (this.header.channels >= 4) {
                    switch (this.header.bits) {
                        case 8: {
                            return this.metadata.hasAlpha() && this.header.channels > 4 ? ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3, 4}, (int[])new int[]{0, 0, 0, 0, 0}, (int)0, (boolean)true, (boolean)false) : ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)0, (boolean)false, (boolean)false);
                        }
                        case 16: {
                            return this.metadata.hasAlpha() && this.header.channels > 4 ? ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3, 4}, (int[])new int[]{0, 0, 0, 0, 0}, (int)1, (boolean)true, (boolean)false) : ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)1, (boolean)false, (boolean)false);
                        }
                        case 32: {
                            return this.metadata.hasAlpha() && this.header.channels > 4 ? ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3, 4}, (int[])new int[]{0, 0, 0, 0, 0}, (int)3, (boolean)true, (boolean)false) : ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2, 3}, (int[])new int[]{0, 0, 0, 0}, (int)3, (boolean)false, (boolean)false);
                        }
                    }
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for CMYK PSD: %d channels/%d bits", this.header.channels, this.header.bits));
            }
        }
        throw new IIOException(String.format("Unsupported PSD MODE: %s (%d channels/%d bits)", this.header.mode, this.header.channels, this.header.bits));
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageTypeInternal(n);
        ColorSpace colorSpace = imageTypeSpecifier.getColorModel().getColorSpace();
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        switch (this.header.mode) {
            case 1: {
                if (imageTypeSpecifier.getNumBands() == 1 && imageTypeSpecifier.getBitsPerBand(0) == 8) {
                    arrayList.add(ImageTypeSpecifiers.createFromBufferedImageType((int)10));
                    break;
                }
                if (imageTypeSpecifier.getNumBands() >= 2 && imageTypeSpecifier.getBitsPerBand(0) == 8) {
                    arrayList.add(ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{1, 0}, (int)0, (boolean)true, (boolean)false));
                    break;
                }
                if (imageTypeSpecifier.getNumBands() == 1 && imageTypeSpecifier.getBitsPerBand(0) == 16) {
                    arrayList.add(ImageTypeSpecifiers.createFromBufferedImageType((int)11));
                    break;
                }
                if (imageTypeSpecifier.getNumBands() < 2 || imageTypeSpecifier.getBitsPerBand(0) != 16) break;
                arrayList.add(ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{1, 0}, (int)1, (boolean)true, (boolean)false));
                break;
            }
            case 3: {
                if (imageTypeSpecifier.getNumBands() == 3 && imageTypeSpecifier.getBitsPerBand(0) == 8) {
                    arrayList.add(ImageTypeSpecifiers.createFromBufferedImageType((int)5));
                    if (colorSpace.isCS_sRGB()) break;
                    arrayList.add(ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{2, 1, 0}, (int)0, (boolean)false, (boolean)false));
                    break;
                }
                if (imageTypeSpecifier.getNumBands() >= 4 && imageTypeSpecifier.getBitsPerBand(0) == 8) {
                    arrayList.add(ImageTypeSpecifiers.createFromBufferedImageType((int)6));
                    if (colorSpace.isCS_sRGB()) break;
                    arrayList.add(ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{3, 2, 1, 0}, (int)0, (boolean)true, (boolean)false));
                    break;
                }
                if (imageTypeSpecifier.getNumBands() == 3 && imageTypeSpecifier.getBitsPerBand(0) == 16) {
                    arrayList.add(ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{2, 1, 0}, (int)1, (boolean)false, (boolean)false));
                    break;
                }
                if (imageTypeSpecifier.getNumBands() < 4 || imageTypeSpecifier.getBitsPerBand(0) != 16) break;
                arrayList.add(ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{3, 2, 1, 0}, (int)1, (boolean)true, (boolean)false));
                break;
            }
            case 4: {
                if (imageTypeSpecifier.getNumBands() == 4 && imageTypeSpecifier.getBitsPerBand(0) == 8) {
                    arrayList.add(ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{3, 2, 1, 0}, (int)0, (boolean)false, (boolean)false));
                    break;
                }
                if (imageTypeSpecifier.getNumBands() == 5 && imageTypeSpecifier.getBitsPerBand(0) == 8) {
                    arrayList.add(ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{4, 3, 2, 1, 0}, (int)0, (boolean)true, (boolean)false));
                    break;
                }
                if (imageTypeSpecifier.getNumBands() == 4 && imageTypeSpecifier.getBitsPerBand(0) == 16) {
                    arrayList.add(ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{3, 2, 1, 0}, (int)1, (boolean)false, (boolean)false));
                    break;
                }
                if (imageTypeSpecifier.getNumBands() != 5 || imageTypeSpecifier.getBitsPerBand(0) != 16) break;
                arrayList.add(ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{4, 3, 2, 1, 0}, (int)1, (boolean)true, (boolean)false));
                break;
            }
        }
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    private ColorSpace getEmbeddedColorSpace() throws IOException {
        this.readImageResources(true);
        if (this.colorSpace == null) {
            ICC_Profile iCC_Profile = null;
            for (PSDImageResource pSDImageResource : this.metadata.imageResources) {
                if (!(pSDImageResource instanceof ICCProfile)) continue;
                iCC_Profile = ((ICCProfile)pSDImageResource).getProfile();
                break;
            }
            this.colorSpace = iCC_Profile == null ? null : ColorSpaces.createColorSpace(iCC_Profile);
        }
        return this.colorSpace;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        int n3;
        this.checkBounds(n);
        if (n > 0) {
            return this.readLayerData(n - 1, imageReadParam);
        }
        BufferedImage bufferedImage = PSDImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n), (int)this.header.width, (int)this.header.height);
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        PSDImageReader.checkReadParamBandSettings((ImageReadParam)imageReadParam, (int)imageTypeSpecifier.getNumBands(), (int)bufferedImage.getSampleModel().getNumBands());
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        PSDImageReader.computeRegions((ImageReadParam)imageReadParam, (int)this.header.width, (int)this.header.height, (BufferedImage)bufferedImage, (Rectangle)rectangle, (Rectangle)rectangle2);
        if (imageReadParam == null) {
            n3 = 1;
            n2 = 1;
        } else {
            n2 = imageReadParam.getSourceXSubsampling();
            n3 = imageReadParam.getSourceYSubsampling();
        }
        this.imageInput.seek(this.metadata.imageDataStart);
        short s = this.imageInput.readShort();
        this.metadata.compression = s;
        int[] nArray = null;
        switch (s) {
            case 0: {
                break;
            }
            case 1: {
                nArray = new int[this.header.channels * this.header.height];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.header.largeFormat ? this.imageInput.readInt() : this.imageInput.readUnsignedShort();
                }
                break;
            }
            case 2: 
            case 3: {
                throw new IIOException("PSD with ZIP compression not supported");
            }
            default: {
                throw new IIOException(String.format("Unknown PSD compression: %d. Expected 0 (none), 1 (RLE), 2 (ZIP) or 3 (ZIP w/prediction).", s));
            }
        }
        this.processImageStarted(n);
        this.readImageData(bufferedImage, imageTypeSpecifier.getColorModel(), rectangle, rectangle2, n2, n3, nArray, s);
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bufferedImage;
    }

    private long findLayerStartPos(int n) {
        long l = this.metadata.layersStart;
        for (int i = 0; i < n; ++i) {
            PSDLayerInfo pSDLayerInfo = this.metadata.layerInfo.get(i);
            for (PSDChannelInfo pSDChannelInfo : pSDLayerInfo.channelInfo) {
                l += pSDChannelInfo.length;
            }
        }
        return l;
    }

    private void readImageData(BufferedImage bufferedImage, ColorModel colorModel, Rectangle rectangle, Rectangle rectangle2, int n, int n2, int[] nArray, int n3) throws IOException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorModel colorModel2 = bufferedImage.getColorModel();
        int n4 = colorModel.createCompatibleSampleModel(1, 1).getNumBands();
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifiers.createGrayscale((int)this.header.bits, (int)colorModel.getTransferType());
        WritableRaster writableRaster2 = imageTypeSpecifier.createBufferedImage(this.header.width, 1).getRaster();
        boolean bl = writableRaster.getDataBuffer().getNumBanks() > 1;
        int n5 = bl ? 1 : writableRaster.getNumBands();
        for (int i = 0; i < n4; ++i) {
            int n6 = bl ? 0 : n5 - 1 - i;
            switch (this.header.bits) {
                case 1: {
                    byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
                    this.read1bitChannel(i, n4, writableRaster.getDataBuffer(), n5, n6, colorModel, byArray, rectangle, rectangle2, n, n2, this.header.width, this.header.height, nArray, n3 == 1);
                    break;
                }
                case 8: {
                    byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
                    this.read8bitChannel(i, n4, writableRaster.getDataBuffer(), n5, n6, colorModel, byArray, rectangle, rectangle2, n, n2, this.header.width, this.header.height, nArray, i * this.header.height, n3 == 1);
                    break;
                }
                case 16: {
                    short[] sArray = ((DataBufferUShort)writableRaster2.getDataBuffer()).getData();
                    this.read16bitChannel(i, n4, writableRaster.getDataBuffer(), n5, n6, colorModel, sArray, rectangle, rectangle2, n, n2, this.header.width, this.header.height, nArray, i * this.header.height, n3 == 1);
                    break;
                }
                case 32: {
                    int[] nArray2 = ((DataBufferInt)writableRaster2.getDataBuffer()).getData();
                    this.read32bitChannel(i, n4, writableRaster.getDataBuffer(), n5, n6, colorModel, nArray2, rectangle, rectangle2, n, n2, this.header.width, this.header.height, nArray, i * this.header.height, n3 == 1);
                    break;
                }
                default: {
                    throw new IIOException(String.format("Unsupported PSD bit depth: %s", this.header.bits));
                }
            }
            if (this.abortRequested()) break;
        }
        if (this.header.bits == 8) {
            this.decomposeAlpha(colorModel2, writableRaster.getDataBuffer(), rectangle2.width, rectangle2.height, writableRaster.getNumBands());
        }
        if (!colorModel.getColorSpace().equals(colorModel2.getColorSpace())) {
            this.convertToDestinationCS(colorModel, colorModel2, writableRaster);
        }
    }

    private void convertToDestinationCS(ColorModel colorModel, ColorModel colorModel2, WritableRaster writableRaster) {
        long l = DEBUG ? System.currentTimeMillis() : 0L;
        WritableRaster writableRaster2 = colorModel2.hasAlpha() ? writableRaster.createWritableChild(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getMinX(), writableRaster.getMinY(), this.createBandList(colorModel.getColorSpace().getNumComponents())) : writableRaster;
        new ColorConvertOp(colorModel.getColorSpace(), colorModel2.getColorSpace(), null).filter(writableRaster2, writableRaster2);
        if (DEBUG) {
            System.out.println("Color conversion " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    private int[] createBandList(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private void processImageProgressForChannel(int n, int n2, int n3, int n4) {
        this.processImageProgress(100.0f * (float)n / (float)n2 + 100.0f * (float)n3 / (float)(n4 * n2));
    }

    private void read32bitChannel(int n, int n2, DataBuffer dataBuffer, int n3, int n4, ColorModel colorModel, int[] nArray, Rectangle rectangle, Rectangle rectangle2, int n5, int n6, int n7, int n8, int[] nArray2, int n9, boolean bl) throws IOException {
        boolean bl2 = colorModel.getColorSpace().getType() == 9;
        int n10 = colorModel.getColorSpace().getNumComponents();
        boolean bl3 = bl2 && n < n10;
        boolean bl4 = dataBuffer.getNumBanks() > 1;
        for (int i = 0; i < n8; ++i) {
            int n11;
            int n12 = n11 = bl ? nArray2[n9 + i] : 4 * n7;
            if (i >= rectangle.y && i < rectangle.y + rectangle.height && i % n6 == 0) {
                int n13;
                if (bl) {
                    try (DataInputStream dataInputStream = PSDUtil.createPackBitsStream(this.imageInput, n11);){
                        for (n13 = 0; n13 < n7; ++n13) {
                            nArray[n13] = dataInputStream.readInt();
                        }
                    }
                } else {
                    this.imageInput.readFully(nArray, 0, n7);
                }
                int n14 = (i - rectangle.y) / n6 * rectangle2.width * n3 + n4;
                for (int j = 0; j < rectangle2.width; ++j) {
                    n13 = nArray[rectangle.x + j * n5];
                    if (bl3) {
                        n13 = -1 - n13;
                    }
                    dataBuffer.setElem(bl4 ? n : 0, n14 + j * n3, n13);
                }
            } else {
                this.imageInput.skipBytes(n11);
            }
            if (this.abortRequested()) break;
            this.processImageProgressForChannel(n, n2, i, n8);
        }
    }

    private void read16bitChannel(int n, int n2, DataBuffer dataBuffer, int n3, int n4, ColorModel colorModel, short[] sArray, Rectangle rectangle, Rectangle rectangle2, int n5, int n6, int n7, int n8, int[] nArray, int n9, boolean bl) throws IOException {
        boolean bl2 = colorModel.getColorSpace().getType() == 9;
        int n10 = colorModel.getColorSpace().getNumComponents();
        boolean bl3 = bl2 && n < n10;
        boolean bl4 = dataBuffer.getNumBanks() > 1;
        for (int i = 0; i < n8; ++i) {
            int n11;
            int n12 = n11 = bl ? nArray[n9 + i] : 2 * n7;
            if (i >= rectangle.y && i < rectangle.y + rectangle.height && i % n6 == 0) {
                int n13;
                if (bl) {
                    try (DataInputStream dataInputStream = PSDUtil.createPackBitsStream(this.imageInput, n11);){
                        for (n13 = 0; n13 < n7; ++n13) {
                            sArray[n13] = dataInputStream.readShort();
                        }
                    }
                } else {
                    this.imageInput.readFully(sArray, 0, n7);
                }
                int n14 = (i - rectangle.y) / n6 * rectangle2.width * n3 + n4;
                for (int j = 0; j < rectangle2.width; ++j) {
                    n13 = sArray[rectangle.x + j * n5];
                    if (bl3) {
                        n13 = (short)(65535 - n13 & 0xFFFF);
                    }
                    dataBuffer.setElem(bl4 ? n : 0, n14 + j * n3, n13);
                }
            } else {
                this.imageInput.skipBytes(n11);
            }
            if (this.abortRequested()) break;
            this.processImageProgressForChannel(n, n2, i, n8);
        }
    }

    private void read8bitChannel(int n, int n2, DataBuffer dataBuffer, int n3, int n4, ColorModel colorModel, byte[] byArray, Rectangle rectangle, Rectangle rectangle2, int n5, int n6, int n7, int n8, int[] nArray, int n9, boolean bl) throws IOException {
        boolean bl2 = colorModel.getColorSpace().getType() == 9;
        int n10 = colorModel.getColorSpace().getNumComponents();
        boolean bl3 = bl2 && n < n10;
        boolean bl4 = dataBuffer.getNumBanks() > 1;
        for (int i = 0; i < n8; ++i) {
            int n11;
            int n12 = n11 = bl ? nArray[n9 + i] : n7;
            if (i >= rectangle.y && i < rectangle.y + rectangle.height && i % n6 == 0) {
                if (bl) {
                    try (DataInputStream dataInputStream = PSDUtil.createPackBitsStream(this.imageInput, n11);){
                        dataInputStream.readFully(byArray, 0, n7);
                    }
                } else {
                    this.imageInput.readFully(byArray, 0, n7);
                }
                int n13 = (i - rectangle.y) / n6 * rectangle2.width * n3 + n4;
                for (int j = 0; j < rectangle2.width; ++j) {
                    byte by = byArray[rectangle.x + j * n5];
                    if (bl3) {
                        by = (byte)(255 - by & 0xFF);
                    }
                    dataBuffer.setElem(bl4 ? n : 0, n13 + j * n3, by);
                }
            } else {
                this.imageInput.skipBytes(n11);
            }
            if (this.abortRequested()) break;
            this.processImageProgressForChannel(n, n2, i, n8);
        }
    }

    private void read1bitChannel(int n, int n2, DataBuffer dataBuffer, int n3, int n4, ColorModel colorModel, byte[] byArray, Rectangle rectangle, Rectangle rectangle2, int n5, int n6, int n7, int n8, int[] nArray, boolean bl) throws IOException {
        int n9 = (rectangle2.width + 7) / 8;
        boolean bl2 = dataBuffer.getNumBanks() > 1;
        for (int i = 0; i < n8; ++i) {
            int n10;
            int n11 = n10 = bl ? nArray[i] : n7;
            if (i >= rectangle.y && i < rectangle.y + rectangle.height && i % n6 == 0) {
                int n12;
                if (bl) {
                    try (DataInputStream dataInputStream = PSDUtil.createPackBitsStream(this.imageInput, n10);){
                        dataInputStream.readFully(byArray, 0, byArray.length);
                    }
                } else {
                    this.imageInput.readFully(byArray, 0, byArray.length);
                }
                int n13 = (i - rectangle.y) / n6 * n9;
                if (n5 == 1 && rectangle.x % 8 == 0) {
                    for (n12 = 0; n12 < n9; ++n12) {
                        byte by = byArray[rectangle.x / 8 + n12 * n5];
                        dataBuffer.setElem(bl2 ? n : 0, n13 + n12, (byte)(~by & 0xFF));
                    }
                } else {
                    n12 = rectangle.x + rectangle.width;
                    int n14 = rectangle.x;
                    for (int j = 0; j < n9; ++j) {
                        int n15 = 0;
                        for (int k = 0; k < 8 && n14 < n12; n14 += n5, ++k) {
                            int n16 = n14 / 8;
                            int n17 = 7 - n14 % 8;
                            int n18 = 1 << n17;
                            int n19 = 7 - k;
                            n15 = (byte)(n15 | (byArray[n16] & n18) >> n17 << n19);
                        }
                        dataBuffer.setElem(bl2 ? n : 0, n13 + j, (byte)(~n15 & 0xFF));
                    }
                }
            } else {
                this.imageInput.skipBytes(n10);
            }
            if (this.abortRequested()) break;
            this.processImageProgressForChannel(n, n2, i, n8);
        }
    }

    private void decomposeAlpha(ColorModel colorModel, DataBuffer dataBuffer, int n, int n2, int n3) {
        block12: {
            if (!colorModel.hasAlpha() || colorModel.getColorSpace().getType() != 5) break block12;
            if (dataBuffer.getNumBanks() > 1) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n4 = j + i * n;
                        int n5 = dataBuffer.getElem(n3 - 1, n4) & 0xFF;
                        if (n5 != 0) {
                            double d = (double)n5 / 255.0;
                            for (int k = 0; k < n3 - 1; ++k) {
                                dataBuffer.setElem(k, n4, PSDImageReader.decompose(dataBuffer.getElem(k, n4) & 0xFF, d));
                            }
                            continue;
                        }
                        for (int k = 0; k < n3 - 1; ++k) {
                            dataBuffer.setElem(k, n4, 0);
                        }
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n6 = (j + i * n) * n3;
                        int n7 = dataBuffer.getElem(n6) & 0xFF;
                        if (n7 != 0) {
                            double d = (double)n7 / 255.0;
                            for (int k = 1; k < n3; ++k) {
                                dataBuffer.setElem(n6 + k, PSDImageReader.decompose(dataBuffer.getElem(n6 + k) & 0xFF, d));
                            }
                            continue;
                        }
                        for (int k = 1; k < n3; ++k) {
                            dataBuffer.setElem(n6 + k, 0);
                        }
                    }
                }
            }
        }
    }

    private static byte decompose(int n, double d) {
        double d2 = (double)n / 255.0;
        return (byte)((d2 / d - (1.0 - d) / d) * 255.0);
    }

    private void readHeader() throws IOException {
        this.assertInput();
        if (this.header == null) {
            this.header = PSDHeader.read(this.imageInput);
            if (!this.header.hasValidDimensions()) {
                this.processWarningOccurred(String.format("Dimensions exceed maximum allowed for %s: %dx%d (max %dx%d)", this.header.largeFormat ? "PSB" : "PSD", this.header.width, this.header.height, this.header.getMaxSize(), this.header.getMaxSize()));
            }
            this.metadata = new PSDMetadata();
            this.metadata.header = this.header;
            if (this.header.mode == 2) {
                this.metadata.colorData = new PSDColorData(this.imageInput);
            } else {
                long l = this.imageInput.readUnsignedInt();
                this.imageInput.skipBytes(l);
            }
            this.metadata.imageResourcesStart = this.imageInput.getStreamPosition();
            this.imageInput.flushBefore(this.imageInput.getStreamPosition());
            if (DEBUG) {
                System.out.println("header: " + this.header);
            }
        }
    }

    private void readImageResources(boolean bl) throws IOException {
        this.readHeader();
        if (bl && this.metadata.imageResources == null || this.metadata.layerAndMaskInfoStart == 0L) {
            this.imageInput.seek(this.metadata.imageResourcesStart);
            long l = this.imageInput.readUnsignedInt();
            if (bl && this.metadata.imageResources == null && l > 0L) {
                long l2 = this.imageInput.getStreamPosition() + l;
                this.metadata.imageResources = new ArrayList<PSDImageResource>();
                while (this.imageInput.getStreamPosition() < l2) {
                    PSDImageResource pSDImageResource = PSDImageResource.read(this.imageInput);
                    this.metadata.imageResources.add(pSDImageResource);
                }
                if (DEBUG) {
                    System.out.println("imageResources: " + this.metadata.imageResources);
                }
                if (this.imageInput.getStreamPosition() != l2) {
                    throw new IIOException("Corrupt PSD document");
                }
            }
            this.metadata.layerAndMaskInfoStart = this.metadata.imageResourcesStart + l + 4L;
        }
    }

    private void readLayerAndMaskInfo(boolean bl) throws IOException {
        this.readImageResources(false);
        if (bl && (this.metadata.layerInfo == null || this.metadata.globalLayerMask == null) || this.metadata.imageDataStart == 0L) {
            long l;
            this.imageInput.seek(this.metadata.layerAndMaskInfoStart);
            long l2 = l = this.header.largeFormat ? this.imageInput.readLong() : this.imageInput.readUnsignedInt();
            if (l > 0L) {
                long l3;
                long l4 = this.imageInput.getStreamPosition();
                long l5 = l3 = this.header.largeFormat ? this.imageInput.readLong() : this.imageInput.readUnsignedInt();
                if (l3 > 0L) {
                    short s = this.imageInput.readShort();
                    this.metadata.layerCount = s;
                    if (bl && this.metadata.layerInfo == null) {
                        this.metadata.layerInfo = this.readLayerInfo(Math.abs(s));
                        this.metadata.layersStart = this.imageInput.getStreamPosition();
                    }
                    long l6 = this.imageInput.getStreamPosition() - l4;
                    long l7 = l3 - (l6 - (long)(this.header.largeFormat ? 8 : 4));
                    this.imageInput.skipBytes(l7);
                } else {
                    this.metadata.layerInfo = Collections.emptyList();
                }
                long l8 = this.imageInput.readUnsignedInt();
                if (l8 > 0L) {
                    if (bl && this.metadata.globalLayerMask == null) {
                        this.metadata.globalLayerMask = new PSDGlobalLayerMask(this.imageInput, l8);
                    }
                } else {
                    this.metadata.globalLayerMask = PSDGlobalLayerMask.NULL_MASK;
                }
                if (bl && DEBUG) {
                    System.out.println("layerInfo: " + this.metadata.layerInfo);
                    System.out.println("globalLayerMask: " + (this.metadata.globalLayerMask != PSDGlobalLayerMask.NULL_MASK ? this.metadata.globalLayerMask : null));
                }
            }
            this.metadata.imageDataStart = this.metadata.layerAndMaskInfoStart + l + (long)(this.header.largeFormat ? 8 : 4);
        }
    }

    private List<PSDLayerInfo> readLayerInfo(int n) throws IOException {
        PSDLayerInfo[] pSDLayerInfoArray = new PSDLayerInfo[n];
        Stack<List> stack = new Stack<List>();
        List list = Collections.emptyList();
        for (int i = 0; i < pSDLayerInfoArray.length; ++i) {
            PSDLayerInfo pSDLayerInfo;
            pSDLayerInfoArray[i] = pSDLayerInfo = new PSDLayerInfo(this.header.largeFormat, this.imageInput);
            if (pSDLayerInfo.isDivider) {
                stack.push(list);
                list = new ArrayList();
            } else if (pSDLayerInfo.isGroup) {
                for (PSDLayerInfo pSDLayerInfo2 : list) {
                    pSDLayerInfo2.groupId = pSDLayerInfo.getLayerId();
                }
                list = (List)stack.pop();
            }
            if (list == Collections.EMPTY_LIST) continue;
            list.add(pSDLayerInfo);
        }
        return Arrays.asList(pSDLayerInfoArray);
    }

    private BufferedImage readLayerData(int n, ImageReadParam imageReadParam) throws IOException {
        int n2 = this.getLayerWidth(n);
        int n3 = this.getLayerHeight(n);
        if (n2 <= 0 || n3 <= 0) {
            return null;
        }
        PSDLayerInfo pSDLayerInfo = this.metadata.layerInfo.get(n);
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageTypeForLayer(n);
        BufferedImage bufferedImage = PSDImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n + 1), (int)n2, (int)n3);
        this.imageInput.seek(this.findLayerStartPos(n));
        Rectangle rectangle = new Rectangle(n2, n3);
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorModel colorModel2 = imageTypeSpecifier.getColorModel();
        WritableRaster writableRaster2 = colorModel2.createCompatibleWritableRaster((int)Math.ceil((double)n2 / (double)colorModel2.getNumComponents()), 1);
        boolean bl = writableRaster.getDataBuffer().getNumBanks() > 1;
        int n4 = bl ? 1 : writableRaster.getNumBands();
        for (PSDChannelInfo pSDChannelInfo : pSDLayerInfo.channelInfo) {
            int n5;
            int n6 = this.imageInput.readUnsignedShort();
            if (pSDChannelInfo.channelId < -1 || n6 != 0 && n6 != 1) {
                this.imageInput.skipBytes(pSDChannelInfo.length - 2L);
                continue;
            }
            int n7 = pSDChannelInfo.channelId == -1 ? writableRaster2.getNumBands() - 1 : pSDChannelInfo.channelId;
            int[] nArray = null;
            switch (n6) {
                case 0: {
                    break;
                }
                case 1: {
                    nArray = new int[pSDLayerInfo.bottom - pSDLayerInfo.top];
                    for (n5 = 0; n5 < nArray.length; ++n5) {
                        nArray[n5] = this.header.largeFormat ? this.imageInput.readInt() : this.imageInput.readUnsignedShort();
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Unsupported layer data. Compression: %d", n6));
                }
            }
            n5 = bl ? 0 : n4 - 1 - n7;
            switch (this.header.bits) {
                case 1: {
                    byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
                    this.read1bitChannel(n7, imageTypeSpecifier.getNumBands(), writableRaster.getDataBuffer(), n4, n5, colorModel2, byArray, rectangle, rectangle, 1, 1, n2, n3, nArray, n6 == 1);
                    break;
                }
                case 8: {
                    byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
                    this.read8bitChannel(n7, imageTypeSpecifier.getNumBands(), writableRaster.getDataBuffer(), n4, n5, colorModel2, byArray, rectangle, rectangle, 1, 1, n2, n3, nArray, 0, n6 == 1);
                    break;
                }
                case 16: {
                    short[] sArray = ((DataBufferUShort)writableRaster2.getDataBuffer()).getData();
                    this.read16bitChannel(n7, imageTypeSpecifier.getNumBands(), writableRaster.getDataBuffer(), n4, n5, colorModel2, sArray, rectangle, rectangle, 1, 1, n2, n3, nArray, 0, n6 == 1);
                    break;
                }
                case 32: {
                    int[] nArray2 = ((DataBufferInt)writableRaster2.getDataBuffer()).getData();
                    this.read32bitChannel(n7, imageTypeSpecifier.getNumBands(), writableRaster.getDataBuffer(), n4, n5, colorModel2, nArray2, rectangle, rectangle, 1, 1, n2, n3, nArray, 0, n6 == 1);
                    break;
                }
                default: {
                    throw new IIOException(String.format("Unknown PSD bit depth: %s", this.header.bits));
                }
            }
            if (this.abortRequested()) break;
        }
        if (!colorModel2.getColorSpace().equals(colorModel.getColorSpace())) {
            this.convertToDestinationCS(colorModel2, colorModel, writableRaster);
        }
        return bufferedImage;
    }

    private ImageTypeSpecifier getRawImageTypeForLayer(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageTypeForCompositeLayer();
        PSDLayerInfo pSDLayerInfo = this.metadata.layerInfo.get(n);
        if (pSDLayerInfo.channelInfo.length > imageTypeSpecifier.getNumBands()) {
            int n2 = 0;
            for (PSDChannelInfo n4 : pSDLayerInfo.channelInfo) {
                if (n4.channelId < -1) continue;
                ++n2;
            }
            if (n2 > imageTypeSpecifier.getNumBands()) {
                int[] nArray = new int[n2];
                int n3 = nArray.length;
                for (int nArray2 = 0; nArray2 < n3; ++nArray2) {
                    nArray[nArray2] = nArray2;
                }
                int[] nArray3 = new int[n2];
                int n4 = nArray3.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    nArray3[n3] = 0;
                }
                return ImageTypeSpecifiers.createBanded((ColorSpace)imageTypeSpecifier.getColorModel().getColorSpace(), (int[])nArray, (int[])nArray3, (int)imageTypeSpecifier.getSampleModel().getDataType(), (boolean)true, (boolean)false);
            }
        }
        return imageTypeSpecifier;
    }

    public int getNumImages(boolean bl) throws IOException {
        this.readLayerAndMaskInfo(false);
        return this.metadata.getLayerCount() + 1;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return super.getStreamMetadata();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkBounds(n);
        this.readImageResources(true);
        this.readLayerAndMaskInfo(true);
        if (this.metadata.compression == -1) {
            this.imageInput.seek(this.metadata.imageDataStart);
            this.metadata.compression = this.imageInput.readShort();
        }
        for (PSDImageResource pSDImageResource : this.metadata.imageResources) {
            if (!(pSDImageResource instanceof PSDDirectoryResource)) continue;
            PSDDirectoryResource pSDDirectoryResource = (PSDDirectoryResource)pSDImageResource;
            try {
                pSDDirectoryResource.initDirectory();
            }
            catch (IOException iOException) {
                this.processWarningOccurred(String.format("Error parsing %s: %s", pSDImageResource.getClass().getSimpleName(), iOException.getMessage()));
            }
        }
        return this.metadata;
    }

    public IIOMetadata getImageMetadata(int n, String string, Set<String> set) throws IOException {
        return super.getImageMetadata(n, string, set);
    }

    public boolean readerSupportsThumbnails() {
        return true;
    }

    private List<PSDThumbnail> getThumbnailResources(int n) throws IOException {
        this.checkBounds(n);
        if (n > 0) {
            return null;
        }
        this.readHeader();
        ArrayList<PSDThumbnail> arrayList = null;
        if (this.metadata.imageResources == null) {
            this.readImageResources(true);
        }
        for (PSDImageResource pSDImageResource : this.metadata.imageResources) {
            if (!(pSDImageResource instanceof PSDThumbnail)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<PSDThumbnail>();
            }
            arrayList.add((PSDThumbnail)pSDImageResource);
        }
        return arrayList;
    }

    public int getNumThumbnails(int n) throws IOException {
        List<PSDThumbnail> list = this.getThumbnailResources(n);
        return list == null ? 0 : list.size();
    }

    private PSDThumbnail getThumbnailResource(int n, int n2) throws IOException {
        List<PSDThumbnail> list = this.getThumbnailResources(n);
        if (list == null) {
            throw new IndexOutOfBoundsException(String.format("image index %d > 0", n));
        }
        return list.get(n2);
    }

    public int getThumbnailWidth(int n, int n2) throws IOException {
        return this.getThumbnailResource(n, n2).getWidth();
    }

    public int getThumbnailHeight(int n, int n2) throws IOException {
        return this.getThumbnailResource(n, n2).getHeight();
    }

    public BufferedImage readThumbnail(int n, int n2) throws IOException {
        PSDThumbnail pSDThumbnail = this.getThumbnailResource(n, n2);
        this.processThumbnailStarted(n, n2);
        this.processThumbnailProgress(0.0f);
        BufferedImage bufferedImage = pSDThumbnail.getThumbnail();
        this.processThumbnailProgress(100.0f);
        this.processThumbnailComplete();
        return bufferedImage;
    }

    public static void main(String[] stringArray) throws IOException {
        int n = 1;
        Rectangle rectangle = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (stringArray[n2].charAt(0) == '-') {
            if (stringArray[n2].equals("-s") || stringArray[n2].equals("--subsampling")) {
                n = Integer.parseInt(stringArray[++n2]);
            } else if (stringArray[n2].equals("-r") || stringArray[n2].equals("--sourceregion")) {
                int n3 = Integer.parseInt(stringArray[++n2]);
                int n4 = Integer.parseInt(stringArray[++n2]);
                try {
                    int n5 = Integer.parseInt(stringArray[n2 + 1]);
                    int n6 = Integer.parseInt(stringArray[n2 + 2]);
                    n2 += 2;
                    rectangle = new Rectangle(n3, n4, n5, n6);
                }
                catch (NumberFormatException numberFormatException) {
                    rectangle = new Rectangle(n3, n4);
                }
                System.out.println("sourceRegion: " + rectangle);
            } else if (stringArray[n2].equals("-l") || stringArray[n2].equals("--layers")) {
                bl = true;
            } else if (stringArray[n2].equals("-t") || stringArray[n2].equals("--thumbnails")) {
                bl2 = true;
            } else {
                System.err.println("Usage: java PSDImageReader [-s <subsample factor>] [-r [<x y>] <w h>] <image file>");
                System.exit(1);
            }
            ++n2;
        }
        PSDImageReader pSDImageReader = new PSDImageReader(null);
        while (n2 < stringArray.length) {
            File file = new File(stringArray[n2]);
            System.out.println();
            System.out.println("file: " + file.getAbsolutePath());
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            pSDImageReader.setInput(imageInputStream);
            pSDImageReader.readHeader();
            System.out.println("imageReader.header: " + pSDImageReader.header);
            pSDImageReader.readImageResources(true);
            System.out.println("imageReader.imageResources: " + pSDImageReader.metadata.imageResources);
            System.out.println();
            pSDImageReader.readLayerAndMaskInfo(true);
            System.out.println("imageReader.layerInfo: " + pSDImageReader.metadata.layerInfo);
            if (bl2 && pSDImageReader.hasThumbnails(0)) {
                int n7 = pSDImageReader.getNumThumbnails(0);
                for (int i = 0; i < n7; ++i) {
                    PSDImageReader.showIt((BufferedImage)pSDImageReader.readThumbnail(0, i), (String)String.format("Thumbnail %d", i));
                }
            }
            long l = System.currentTimeMillis();
            ImageReadParam imageReadParam = pSDImageReader.getDefaultReadParam();
            if (rectangle != null) {
                imageReadParam.setSourceRegion(rectangle);
            }
            if (n > 1) {
                imageReadParam.setSourceSubsampling(n, n, 0, 0);
            }
            BufferedImage bufferedImage = pSDImageReader.read(0, imageReadParam);
            System.out.println("read time: " + (System.currentTimeMillis() - l));
            System.out.println("image: " + bufferedImage);
            if (bufferedImage.getType() == 0) {
                try {
                    ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1000), null);
                    GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                    bufferedImage = colorConvertOp.filter(bufferedImage, graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getTransparency()));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bufferedImage = ImageUtil.accelerate((Image)bufferedImage);
                }
                System.out.println("conversion time: " + (System.currentTimeMillis() - l));
                System.out.println("image: " + bufferedImage);
            }
            PSDImageReader.showIt((BufferedImage)bufferedImage, (String)file.getName());
            if (bl) {
                int n8 = pSDImageReader.getNumImages(true);
                for (int i = 1; i < n8; ++i) {
                    l = System.currentTimeMillis();
                    BufferedImage bufferedImage2 = pSDImageReader.read(i);
                    System.out.println("layer read time: " + (System.currentTimeMillis() - l));
                    System.err.println("layer: " + bufferedImage2);
                    if (bufferedImage2 != null && bufferedImage2.getType() == 0) {
                        try {
                            ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1000), null);
                            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                            bufferedImage2 = colorConvertOp.filter(bufferedImage2, graphicsConfiguration.createCompatibleImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getTransparency()));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            bufferedImage2 = ImageUtil.accelerate((Image)bufferedImage2);
                        }
                        System.out.println("layer conversion time: " + (System.currentTimeMillis() - l));
                        System.out.println("layer: " + bufferedImage2);
                    }
                    PSDImageReader.showIt((BufferedImage)bufferedImage2, (String)("layer " + i));
                }
            }
            ++n2;
        }
    }
}

