/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics.android.integrations.tune;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.segment.analytics.Analytics;
import com.segment.analytics.ValueMap;
import com.segment.analytics.integrations.IdentifyPayload;
import com.segment.analytics.integrations.Integration;
import com.segment.analytics.integrations.Logger;
import com.segment.analytics.integrations.TrackPayload;
import com.tune.Tune;
import com.tune.TuneEvent;
import com.tune.ma.application.TuneActivity;

public class TuneIntegration
extends Integration<Tune> {
    private static final String TUNE_KEY = "TUNE";
    private Logger logger;
    final Tune tune;
    final String advertiserId;
    final String conversionKey;
    final boolean turnOnTMA;
    final String gcmSenderId;
    public static final Integration.Factory FACTORY = new Integration.Factory(){

        public Integration<?> create(ValueMap settings, Analytics analytics) {
            Logger logger = analytics.logger(TuneIntegration.TUNE_KEY);
            Application context = analytics.getApplication();
            String advertiserId = settings.getString("advertiserId");
            String conversionKey = settings.getString("conversionKey");
            boolean turnOnTMA = settings.getBoolean("turnOnTMA", false);
            String gcmSenderId = settings.getString("gcmSenderId");
            if (TextUtils.isEmpty((CharSequence)advertiserId)) {
                logger.info("Please add TUNE advertiser id in Segment settings.", new Object[0]);
                return null;
            }
            if (TextUtils.isEmpty((CharSequence)conversionKey)) {
                logger.info("Please add TUNE conversion key in Segment settings.", new Object[0]);
                return null;
            }
            return new TuneIntegration((Context)context, advertiserId, conversionKey, turnOnTMA, gcmSenderId, logger);
        }

        public String key() {
            return TuneIntegration.TUNE_KEY;
        }
    };

    public TuneIntegration(Context context, String advertiserId, String conversionKey, boolean turnOnTMA, String gcmSenderId, Logger logger) {
        this.logger = logger;
        logger.verbose("Initializing TuneIntegration, advertiserId: %s, conversionKey: %s", new Object[]{advertiserId, conversionKey});
        this.advertiserId = advertiserId;
        this.conversionKey = conversionKey;
        this.turnOnTMA = turnOnTMA;
        this.gcmSenderId = gcmSenderId;
        this.tune = Tune.init((Context)context, (String)advertiserId, (String)conversionKey, (boolean)turnOnTMA);
        if (this.turnOnTMA && !TextUtils.isEmpty((CharSequence)gcmSenderId)) {
            this.tune.setPushNotificationSenderId(gcmSenderId);
        }
        logger.verbose("TuneIntegration initialized.", new Object[0]);
    }

    public void onActivityStarted(Activity activity) {
        this.logger.verbose("TuneIntegration onActivityStarted", new Object[0]);
        if (this.turnOnTMA) {
            TuneActivity.onStart((Activity)activity);
        }
    }

    public void onActivityResumed(Activity activity) {
        this.logger.verbose("TuneIntegration onActivityResumed: Calling TUNE measureSession", new Object[0]);
        if (this.turnOnTMA) {
            TuneActivity.onResume((Activity)activity);
        }
        this.tune.setReferralSources(activity);
        this.tune.measureSession();
    }

    public void onActivityStopped(Activity activity) {
        this.logger.verbose("TuneIntegration onActivityStopped", new Object[0]);
        if (this.turnOnTMA) {
            TuneActivity.onStop((Activity)activity);
        }
    }

    public void identify(IdentifyPayload identify) {
        this.logger.verbose("TuneIntegration identify: Setting TUNE user identifiers", new Object[0]);
        this.tune.setUserId(identify.userId());
        this.tune.setPhoneNumber(identify.traits().phone());
        this.tune.setUserEmail(identify.traits().email());
        this.tune.setUserName(identify.traits().username());
    }

    public void track(TrackPayload track) {
        String eventName = track.event();
        if (eventName.equals("Completed Order")) {
            eventName = "purchase";
        }
        this.logger.verbose("TuneIntegration track: Calling TUNE measureEvent with %s", new Object[]{eventName});
        TuneEvent event = new TuneEvent(eventName);
        event.withRevenue(track.properties().revenue());
        event.withCurrencyCode(track.properties().currency());
        event.withAdvertiserRefId(track.properties().orderId());
        event.withContentId(track.properties().productId());
        event.withContentType(track.properties().category());
        this.tune.measureEvent(event);
    }

    public void reset() {
        this.logger.verbose("TuneIntegration reset: Clearing TUNE user identifiers", new Object[0]);
        this.tune.setUserId(null);
        this.tune.setPhoneNumber(null);
        this.tune.setUserEmail(null);
        this.tune.setUserName(null);
    }

    public Tune getUnderlyingInstance() {
        return this.tune;
    }
}

