/*
 * Decompiled with CFR 0.152.
 */
package com.tune.smartwhere;

import android.content.Context;
import com.tune.TuneUtils;
import java.lang.reflect.Method;
import java.util.HashMap;

public class TuneSmartWhere {
    private static volatile TuneSmartWhere instance = null;
    public static final String TUNE_SMARTWHERE_COM_PROXIMITY_LIBRARY_PROXIMITYCONTROL = "com.proximity.library.ProximityControl";
    public static final String TUNE_SMARTWHERE_NOTIFICATION_SERVICE = "com.tune.smartwhere.TuneSmartWhereNotificationService";
    public static final String TUNE_SMARTWHERE_API_KEY = "API_KEY";
    public static final String TUNE_SMARTWHERE_API_SECRET = "API_SECRET";
    public static final String TUNE_SMARTWHERE_APPLICATION_ID = "APPLICATION_ID";
    public static final String TUNE_SMARTWHERE_SERVICE_AUTO_START = "SERVICE_AUTO_START";
    public static final String TUNE_SMARTWHERE_ENABLE_GEOFENCE_RANGING = "ENABLE_GEOFENCE_RANGING";
    public static final String TUNE_SMARTWHERE_PROMPT_FOR_LOCATION_PERMISSION = "PROMPT_FOR_LOCATION_PERMISSION";
    public static final String TUNE_SMARTWHERE_NOTIFICATION_HANDLER_SERVICE = "NOTIFICATION_HANDLER_SERVICE";
    public static final String TUNE_SMARTWHERE_DEBUG_LOG = "DEBUG_LOG";
    public static final String TUNE_SMARTWHERE_PACKAGE_NAME = "PACKAGE_NAME";
    public static final String TUNE_SMARTWHERE_METHOD_CONFIGURE_SERVICE = "configureService";
    public static final String TUNE_SMARTWHERE_METHOD_START_SERVICE = "startService";
    public static final String TUNE_SMARTWHERE_METHOD_STOP_SERVICE = "stopService";

    protected TuneSmartWhere() {
    }

    public static synchronized TuneSmartWhere getInstance() {
        if (instance == null) {
            instance = new TuneSmartWhere();
        }
        return instance;
    }

    public boolean isSmartWhereAvailable() {
        return this.classForName(TUNE_SMARTWHERE_COM_PROXIMITY_LIBRARY_PROXIMITYCONTROL) != null;
    }

    public void startMonitoring(Context context, String tuneAdvertiserId, String tuneConversionKey, boolean debugMode) {
        Class targetClass = this.classForName(TUNE_SMARTWHERE_COM_PROXIMITY_LIBRARY_PROXIMITYCONTROL);
        if (targetClass != null) {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put(TUNE_SMARTWHERE_API_KEY, tuneAdvertiserId);
            config.put(TUNE_SMARTWHERE_API_SECRET, tuneConversionKey);
            config.put(TUNE_SMARTWHERE_APPLICATION_ID, tuneAdvertiserId);
            config.put(TUNE_SMARTWHERE_SERVICE_AUTO_START, "true");
            config.put(TUNE_SMARTWHERE_ENABLE_GEOFENCE_RANGING, "true");
            config.put(TUNE_SMARTWHERE_PROMPT_FOR_LOCATION_PERMISSION, "false");
            config.put(TUNE_SMARTWHERE_NOTIFICATION_HANDLER_SERVICE, TUNE_SMARTWHERE_NOTIFICATION_SERVICE);
            if (debugMode) {
                config.put(TUNE_SMARTWHERE_DEBUG_LOG, "true");
            }
            try {
                Method configureService = targetClass.getMethod(TUNE_SMARTWHERE_METHOD_CONFIGURE_SERVICE, Context.class, HashMap.class);
                configureService.invoke((Object)targetClass, context, config);
                Method startService = targetClass.getMethod(TUNE_SMARTWHERE_METHOD_START_SERVICE, Context.class);
                startService.invoke((Object)targetClass, context);
            }
            catch (Exception e) {
                TuneUtils.log("TuneSmartWhere.startMonitoring: " + e.getLocalizedMessage());
            }
        }
    }

    public void stopMonitoring(Context context) {
        Class targetClass = this.classForName(TUNE_SMARTWHERE_COM_PROXIMITY_LIBRARY_PROXIMITYCONTROL);
        if (targetClass != null) {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put(TUNE_SMARTWHERE_SERVICE_AUTO_START, "false");
            try {
                Method configureService = targetClass.getMethod(TUNE_SMARTWHERE_METHOD_CONFIGURE_SERVICE, Context.class, HashMap.class);
                configureService.invoke((Object)targetClass, context, config);
                Method stopService = targetClass.getMethod(TUNE_SMARTWHERE_METHOD_STOP_SERVICE, Context.class);
                stopService.invoke((Object)targetClass, context);
            }
            catch (Exception e) {
                TuneUtils.log("TuneSmartWhere.stopMonitoring: " + e.getLocalizedMessage());
            }
        }
    }

    public void setDebugMode(Context context, final boolean mode) {
        Class targetClass = this.classForName(TUNE_SMARTWHERE_COM_PROXIMITY_LIBRARY_PROXIMITYCONTROL);
        if (targetClass != null) {
            HashMap<String, String> config = new HashMap<String, String>(){
                {
                    this.put(TuneSmartWhere.TUNE_SMARTWHERE_DEBUG_LOG, mode ? "true" : "false");
                }
            };
            try {
                Method configureService = targetClass.getMethod(TUNE_SMARTWHERE_METHOD_CONFIGURE_SERVICE, Context.class, HashMap.class);
                configureService.invoke((Object)targetClass, context, config);
            }
            catch (Exception e) {
                TuneUtils.log("TuneSmartWhere.setDebugMode: " + e.getLocalizedMessage());
            }
        }
    }

    public void setPackageName(Context context, final String packageName) {
        Class targetClass = this.classForName(TUNE_SMARTWHERE_COM_PROXIMITY_LIBRARY_PROXIMITYCONTROL);
        if (targetClass != null) {
            HashMap<String, String> config = new HashMap<String, String>(){
                {
                    this.put(TuneSmartWhere.TUNE_SMARTWHERE_PACKAGE_NAME, packageName);
                }
            };
            try {
                Method configureService = targetClass.getMethod(TUNE_SMARTWHERE_METHOD_CONFIGURE_SERVICE, Context.class, HashMap.class);
                configureService.invoke((Object)targetClass, context, config);
            }
            catch (Exception e) {
                TuneUtils.log("TuneSmartWhere.setPackageName: " + e.getLocalizedMessage());
            }
        }
    }

    protected static synchronized void setInstance(TuneSmartWhere tuneProximity) {
        instance = tuneProximity;
    }

    protected Class classForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

