/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.utils;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.Map;

public class TuneSharedPrefsDelegate {
    private SharedPreferences prefs;

    public TuneSharedPrefsDelegate(Context context, String name) {
        this.prefs = context.getSharedPreferences(name, 0);
    }

    public synchronized void saveToSharedPreferences(String prefsKey, String prefsValue) {
        this.prefs.edit().putString(prefsKey, prefsValue).apply();
    }

    public synchronized void saveBooleanToSharedPreferences(String prefsKey, boolean prefsValue) {
        this.prefs.edit().putBoolean(prefsKey, prefsValue).apply();
    }

    public synchronized String getStringFromSharedPreferences(String prefsKey) {
        return this.getStringFromSharedPreferences(prefsKey, "");
    }

    public synchronized String getStringFromSharedPreferences(String prefsKey, String defaultValue) {
        try {
            return this.prefs.getString(prefsKey, defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    public synchronized boolean getBooleanFromSharedPreferences(String prefsKey) {
        return this.getBooleanFromSharedPreferences(prefsKey, false);
    }

    public synchronized boolean getBooleanFromSharedPreferences(String prefsKey, boolean defaultValue) {
        return this.prefs.getBoolean(prefsKey, defaultValue);
    }

    public synchronized boolean contains(String prefsKey) {
        return this.prefs.contains(prefsKey);
    }

    public synchronized void clearSharedPreferences() {
        this.prefs.edit().clear().apply();
    }

    public synchronized void remove(String key) {
        this.prefs.edit().remove(key).apply();
    }

    public synchronized Map<String, ?> getAll() {
        return this.prefs.getAll();
    }
}

