/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.utils;

import com.tune.ma.utils.TuneStringUtils;
import java.util.NoSuchElementException;

public final class TuneOptional<T> {
    private static final TuneOptional<?> EMPTY = new TuneOptional();
    private final T value;

    private TuneOptional() {
        this.value = null;
    }

    public static <T> TuneOptional<T> empty() {
        TuneOptional<?> t = EMPTY;
        return t;
    }

    private TuneOptional(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    public static <T> TuneOptional<T> of(T value) {
        return new TuneOptional<T>(value);
    }

    public static <T> TuneOptional<T> ofNullable(T value) {
        if (value == null) {
            return TuneOptional.empty();
        }
        return TuneOptional.of(value);
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TuneOptional)) {
            return false;
        }
        TuneOptional other = (TuneOptional)obj;
        return this.value == null ? other.value == null : this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public String toString() {
        return this.value != null ? TuneStringUtils.format("Optional[%s]", this.value) : "Optional.empty";
    }
}

