/*
 * Decompiled with CFR 0.152.
 */
package com.tune.ma.utils;

import com.tune.ma.utils.TuneStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TuneJsonUtils {
    private static String tabWidth = "  ";
    private static int cutOffDepth = 2;

    public static ArrayList<String> JSONArrayToStringArrayList(JSONArray jsonArray) {
        ArrayList<String> convertedList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                convertedList.add(jsonArray.getString(i));
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return convertedList;
    }

    public static String getString(JSONObject json, String key) {
        try {
            return json.getString(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static JSONObject getJSONObject(JSONObject json, String key) {
        try {
            return json.getJSONObject(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static void put(JSONObject json, String key, Object value) {
        try {
            if (value == null) {
                json.put(key, JSONObject.NULL);
                return;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                if (map.size() == 0) {
                    json.put(key, JSONObject.NULL);
                    return;
                }
                JSONObject mapJson = new JSONObject();
                for (Map.Entry thisEntry : map.entrySet()) {
                    String mapKey = (String)thisEntry.getKey();
                    Object mapValue = thisEntry.getValue();
                    if (mapValue instanceof List) {
                        List list = (List)mapValue;
                        mapJson.put(mapKey, (Object)TuneJsonUtils.listToJson(list));
                        continue;
                    }
                    mapJson.put(mapKey, mapValue);
                }
                json.put(key, (Object)mapJson);
                return;
            }
            if (value instanceof List) {
                List list = (List)value;
                if (list.size() == 0) {
                    json.put(key, JSONObject.NULL);
                    return;
                }
                json.put(key, (Object)TuneJsonUtils.listToJson(list));
                return;
            }
            json.put(key, value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static String getPrettyJson(JSONObject jsonObject) {
        try {
            return jsonObject.toString(2);
        }
        catch (JSONException e) {
            return "Error building pretty json!";
        }
    }

    public static JSONArray listToJson(List list) {
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < list.size(); ++i) {
            try {
                jsonArray.put(i, list.get(i));
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonArray;
    }

    private static String getTabs(int level) {
        StringBuilder result = new StringBuilder();
        if (level < cutOffDepth + 1) {
            for (int i = 0; i < level; ++i) {
                result.append(tabWidth);
            }
        }
        return result.toString();
    }

    private static String prettyPrintJson(JSONObject jsonObject, int level) throws JSONException {
        Iterator keys = jsonObject.keys();
        StringBuilder result = new StringBuilder();
        LinkedList list = new LinkedList();
        while (keys.hasNext()) {
            list.add(keys.next());
        }
        Collections.sort(list);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object obj = jsonObject.get(key);
            if (obj instanceof JSONObject) {
                result.append(TuneStringUtils.format("%s\"%s\": ", TuneJsonUtils.getTabs(level), key));
                result.append(TuneJsonUtils.ppAnalyticsEvent((JSONObject)obj, level));
            } else if (obj instanceof JSONArray) {
                result.append(TuneStringUtils.format("%s\"%s\": ", TuneJsonUtils.getTabs(level), key));
                result.append(TuneJsonUtils.ppJSONArray((JSONArray)obj, level));
            } else if (obj instanceof String) {
                result.append(TuneStringUtils.format("%s\"%s\": \"%s\"", TuneJsonUtils.getTabs(level), key, obj.toString()));
            } else {
                result.append(TuneStringUtils.format("%s\"%s\": %s", TuneJsonUtils.getTabs(level), key, obj.toString()));
            }
            if (iter.hasNext()) {
                result.append(", ");
            }
            result.append(level > cutOffDepth ? "" : "\n");
        }
        return result.toString();
    }

    private static String prettyPrintJson(JSONArray jsonObject, int level) throws JSONException {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < jsonObject.length(); ++i) {
            Object obj = jsonObject.get(i);
            if (obj instanceof JSONObject) {
                result.append(TuneJsonUtils.ppAnalyticsEvent((JSONObject)obj, level));
            } else if (obj instanceof JSONArray) {
                result.append(TuneJsonUtils.ppJSONArray((JSONArray)obj, level));
            } else if (obj instanceof String) {
                result.append(TuneStringUtils.format("%s\"%s\"", TuneJsonUtils.getTabs(level), obj.toString()));
            } else {
                result.append(TuneStringUtils.format("%s%s", TuneJsonUtils.getTabs(level), obj.toString()));
            }
            if (i < jsonObject.length()) {
                result.append(", ");
            }
            result.append(level > cutOffDepth ? "" : "\n");
        }
        return result.toString();
    }

    public static String ppAnalyticsEvent(JSONObject o, int level) throws JSONException {
        StringBuilder result = new StringBuilder();
        String r = TuneJsonUtils.prettyPrintJson(o, level + 1);
        result.append(TuneStringUtils.format("%s{%s", TuneJsonUtils.getTabs(level), level >= cutOffDepth || r.length() == 0 ? "" : "\n"));
        result.append(r);
        result.append(TuneStringUtils.format("%s}", level >= cutOffDepth || r.length() == 0 ? "" : TuneJsonUtils.getTabs(level)));
        return result.toString();
    }

    private static String ppJSONArray(JSONArray o, int level) throws JSONException {
        StringBuilder result = new StringBuilder();
        String r = TuneJsonUtils.prettyPrintJson(o, level + 1);
        result.append(TuneStringUtils.format("[%s", level >= cutOffDepth || r.length() == 0 ? "" : "\n"));
        result.append(r);
        result.append(TuneStringUtils.format("%s]", level >= cutOffDepth || r.length() == 0 ? "" : TuneJsonUtils.getTabs(level)));
        return result.toString();
    }
}

